// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_video_pixel_format.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"

namespace blink {



constexpr const char* const V8VideoPixelFormat::string_table_[] = {
"I420", "I420P10", "I420P12", "I420A", "I420AP10", "I422", "I422P10", "I422P12", "I422A", "I422AP10", "I444", "I444P10", "I444P12", "I444A", "I444AP10", "NV12", "RGBA", "RGBX", "BGRA", "BGRX"
};

V8VideoPixelFormat V8VideoPixelFormat::Create(v8::Isolate* isolate, v8::Local<v8::Value> value, ExceptionState& exception_state) {
  const auto& result = bindings::FindIndexInEnumStringTable(isolate, value, string_table_, "VideoPixelFormat", exception_state);
return result.has_value() ? V8VideoPixelFormat(static_cast<Enum>(result.value())) : V8VideoPixelFormat();
}

std::optional<V8VideoPixelFormat> V8VideoPixelFormat::Create(const String& value) {
  const auto& result = bindings::FindIndexInEnumStringTable(value, string_table_);
if (!result)
  return std::nullopt;
return V8VideoPixelFormat(static_cast<Enum>(result.value()));
}


static_assert(std::is_trivially_copyable<V8VideoPixelFormat>::value, "");






}  // namespace blink
