// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_CONFIGURATION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_CONFIGURATION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_color_gamut.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_hdr_metadata_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_transfer_function.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT VideoConfiguration : public bindings::InputDictionaryBase {
  
  public:
static VideoConfiguration* Create() {
  return MakeGarbageCollected<VideoConfiguration>();
}
static VideoConfiguration* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoConfiguration>(isolate);
}
static VideoConfiguration* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoConfiguration();
explicit  VideoConfiguration(v8::Isolate* isolate);

bool hasBitrate() const {
  return true;
}
uint32_t bitrate() const {
  return member_bitrate_;
}
void setBitrate(uint32_t value) {
  member_bitrate_ = value;
}

bool hasColorGamut() const {
  return has_color_gamut_;
}
V8ColorGamut colorGamut() const {
  DCHECK(hasColorGamut());
return member_color_gamut_;
}
V8ColorGamut getColorGamutOr(V8ColorGamut fallback_value) const {
  if (!hasColorGamut()) {
  return fallback_value;
}
return member_color_gamut_;
}
void setColorGamut(V8ColorGamut value) {
  member_color_gamut_ = value;
has_color_gamut_ = true;
}
void setColorGamut(V8ColorGamut::Enum value) {
  member_color_gamut_ = V8ColorGamut(value);
has_color_gamut_ = true;
}

bool hasContentType() const {
  return true;
}
const String& contentType() const {
  return member_content_type_;
}
void setContentType(const String& value);
void setContentType(String&& value);

bool hasFramerate() const {
  return true;
}
double framerate() const {
  return member_framerate_;
}
void setFramerate(double value) {
  member_framerate_ = value;
}

bool hasHdrMetadataType() const {
  return has_hdr_metadata_type_;
}
V8HdrMetadataType hdrMetadataType() const {
  DCHECK(hasHdrMetadataType());
return member_hdr_metadata_type_;
}
V8HdrMetadataType getHdrMetadataTypeOr(V8HdrMetadataType fallback_value) const {
  if (!hasHdrMetadataType()) {
  return fallback_value;
}
return member_hdr_metadata_type_;
}
void setHdrMetadataType(V8HdrMetadataType value) {
  member_hdr_metadata_type_ = value;
has_hdr_metadata_type_ = true;
}
void setHdrMetadataType(V8HdrMetadataType::Enum value) {
  member_hdr_metadata_type_ = V8HdrMetadataType(value);
has_hdr_metadata_type_ = true;
}

bool hasHeight() const {
  return true;
}
uint32_t height() const {
  return member_height_;
}
void setHeight(uint32_t value) {
  member_height_ = value;
}

bool hasScalabilityMode() const {
  return has_scalability_mode_;
}
const String& scalabilityMode() const {
  DCHECK(hasScalabilityMode());
return member_scalability_mode_;
}
String getScalabilityModeOr(const String& fallback_value) const;
String getScalabilityModeOr(String&& fallback_value) const;
void setScalabilityMode(const String& value);
void setScalabilityMode(String&& value);

bool hasSpatialScalability() const {
  return has_spatial_scalability_;
}
bool spatialScalability() const {
  DCHECK(hasSpatialScalability());
return member_spatial_scalability_;
}
bool getSpatialScalabilityOr(bool fallback_value) const {
  if (!hasSpatialScalability()) {
  return fallback_value;
}
return member_spatial_scalability_;
}
void setSpatialScalability(bool value) {
  member_spatial_scalability_ = value;
has_spatial_scalability_ = true;
}

bool hasTransferFunction() const {
  return has_transfer_function_;
}
V8TransferFunction transferFunction() const {
  DCHECK(hasTransferFunction());
return member_transfer_function_;
}
V8TransferFunction getTransferFunctionOr(V8TransferFunction fallback_value) const {
  if (!hasTransferFunction()) {
  return fallback_value;
}
return member_transfer_function_;
}
void setTransferFunction(V8TransferFunction value) {
  member_transfer_function_ = value;
has_transfer_function_ = true;
}
void setTransferFunction(V8TransferFunction::Enum value) {
  member_transfer_function_ = V8TransferFunction(value);
has_transfer_function_ = true;
}

bool hasWidth() const {
  return true;
}
uint32_t width() const {
  return member_width_;
}
void setWidth(uint32_t value) {
  member_width_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 10;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_color_gamut_ = false;
bool has_hdr_metadata_type_ = false;
bool has_scalability_mode_ = false;
bool has_spatial_scalability_ = false;
bool has_transfer_function_ = false;

uint32_t member_bitrate_;
V8ColorGamut member_color_gamut_{static_cast<V8ColorGamut::Enum>(0)};
String member_content_type_;
double member_framerate_;
V8HdrMetadataType member_hdr_metadata_type_{static_cast<V8HdrMetadataType::Enum>(0)};
uint32_t member_height_;
String member_scalability_mode_;
bool member_spatial_scalability_;
V8TransferFunction member_transfer_function_{static_cast<V8TransferFunction::Enum>(0)};
uint32_t member_width_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_CONFIGURATION_H_
