// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_USB_DEVICE_FILTER_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_USB_DEVICE_FILTER_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT USBDeviceFilter : public bindings::InputDictionaryBase {
  
  public:
static USBDeviceFilter* Create() {
  return MakeGarbageCollected<USBDeviceFilter>();
}
static USBDeviceFilter* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<USBDeviceFilter>(isolate);
}
static USBDeviceFilter* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  USBDeviceFilter();
explicit  USBDeviceFilter(v8::Isolate* isolate);

bool hasClassCode() const {
  return has_class_code_;
}
uint8_t classCode() const {
  DCHECK(hasClassCode());
return member_class_code_;
}
uint8_t getClassCodeOr(uint8_t fallback_value) const {
  if (!hasClassCode()) {
  return fallback_value;
}
return member_class_code_;
}
void setClassCode(uint8_t value) {
  member_class_code_ = value;
has_class_code_ = true;
}

bool hasProductId() const {
  return has_product_id_;
}
uint16_t productId() const {
  DCHECK(hasProductId());
return member_product_id_;
}
uint16_t getProductIdOr(uint16_t fallback_value) const {
  if (!hasProductId()) {
  return fallback_value;
}
return member_product_id_;
}
void setProductId(uint16_t value) {
  member_product_id_ = value;
has_product_id_ = true;
}

bool hasProtocolCode() const {
  return has_protocol_code_;
}
uint8_t protocolCode() const {
  DCHECK(hasProtocolCode());
return member_protocol_code_;
}
uint8_t getProtocolCodeOr(uint8_t fallback_value) const {
  if (!hasProtocolCode()) {
  return fallback_value;
}
return member_protocol_code_;
}
void setProtocolCode(uint8_t value) {
  member_protocol_code_ = value;
has_protocol_code_ = true;
}

bool hasSerialNumber() const {
  return has_serial_number_;
}
const String& serialNumber() const {
  DCHECK(hasSerialNumber());
return member_serial_number_;
}
String getSerialNumberOr(const String& fallback_value) const;
String getSerialNumberOr(String&& fallback_value) const;
void setSerialNumber(const String& value);
void setSerialNumber(String&& value);

bool hasSubclassCode() const {
  return has_subclass_code_;
}
uint8_t subclassCode() const {
  DCHECK(hasSubclassCode());
return member_subclass_code_;
}
uint8_t getSubclassCodeOr(uint8_t fallback_value) const {
  if (!hasSubclassCode()) {
  return fallback_value;
}
return member_subclass_code_;
}
void setSubclassCode(uint8_t value) {
  member_subclass_code_ = value;
has_subclass_code_ = true;
}

bool hasVendorId() const {
  return has_vendor_id_;
}
uint16_t vendorId() const {
  DCHECK(hasVendorId());
return member_vendor_id_;
}
uint16_t getVendorIdOr(uint16_t fallback_value) const {
  if (!hasVendorId()) {
  return fallback_value;
}
return member_vendor_id_;
}
void setVendorId(uint16_t value) {
  member_vendor_id_ = value;
has_vendor_id_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_class_code_ = false;
bool has_product_id_ = false;
bool has_protocol_code_ = false;
bool has_serial_number_ = false;
bool has_subclass_code_ = false;
bool has_vendor_id_ = false;

uint8_t member_class_code_;
uint16_t member_product_id_;
uint8_t member_protocol_code_;
String member_serial_number_;
uint8_t member_subclass_code_;
uint16_t member_vendor_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_USB_DEVICE_FILTER_H_
