// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_WORKLETANIMATIONEFFECT_WORKLETGROUPEFFECT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_WORKLETANIMATIONEFFECT_WORKLETGROUPEFFECT_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class ScriptState;
class WorkletAnimationEffect;
class WorkletGroupEffect;

class MODULES_EXPORT V8UnionWorkletAnimationEffectOrWorkletGroupEffect final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kWorkletAnimationEffect, kWorkletGroupEffect
};

static V8UnionWorkletAnimationEffectOrWorkletGroupEffect* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionWorkletAnimationEffectOrWorkletGroupEffect(WorkletAnimationEffect* value) : content_type_(ContentType::kWorkletAnimationEffect), member_worklet_animation_effect_(value) {
  DCHECK(value);
}
explicit  V8UnionWorkletAnimationEffectOrWorkletGroupEffect(WorkletGroupEffect* value) : content_type_(ContentType::kWorkletGroupEffect), member_worklet_group_effect_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsWorkletAnimationEffect() const {
  return content_type_ == ContentType::kWorkletAnimationEffect;
}
WorkletAnimationEffect* GetAsWorkletAnimationEffect() const {
  DCHECK_EQ(content_type_, ContentType::kWorkletAnimationEffect);
return member_worklet_animation_effect_.Get();
}
void Set(WorkletAnimationEffect* value) {
  DCHECK(value);
Clear();
member_worklet_animation_effect_ = value;
content_type_ = ContentType::kWorkletAnimationEffect;
}

bool IsWorkletGroupEffect() const {
  return content_type_ == ContentType::kWorkletGroupEffect;
}
WorkletGroupEffect* GetAsWorkletGroupEffect() const {
  DCHECK_EQ(content_type_, ContentType::kWorkletGroupEffect);
return member_worklet_group_effect_.Get();
}
void Set(WorkletGroupEffect* value) {
  DCHECK(value);
Clear();
member_worklet_group_effect_ = value;
content_type_ = ContentType::kWorkletGroupEffect;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(WorkletAnimationEffect or WorkletGroupEffect)";
}

ContentType content_type_;

Member<WorkletAnimationEffect> member_worklet_animation_effect_;
Member<WorkletGroupEffect> member_worklet_group_effect_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_WORKLETANIMATIONEFFECT_WORKLETGROUPEFFECT_H_
