// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_workletanimationeffect_workletgroupeffect.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_worklet_animation_effect.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_worklet_group_effect.h"
#include "third_party/blink/renderer/modules/animationworklet/worklet_animation_effect.h"
#include "third_party/blink/renderer/modules/animationworklet/worklet_group_effect.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionWorkletAnimationEffectOrWorkletGroupEffect* V8UnionWorkletAnimationEffectOrWorkletGroupEffect::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8WorkletGroupEffect::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8WorkletGroupEffect::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionWorkletAnimationEffectOrWorkletGroupEffect>(blink_value);
}
if (V8WorkletAnimationEffect::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8WorkletAnimationEffect::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionWorkletAnimationEffectOrWorkletGroupEffect>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionWorkletAnimationEffectOrWorkletGroupEffect::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kWorkletAnimationEffect: {
    return ToV8Traits<WorkletAnimationEffect>::ToV8(script_state, member_worklet_animation_effect_.Get());
  }
  case ContentType::kWorkletGroupEffect: {
    return ToV8Traits<WorkletGroupEffect>::ToV8(script_state, member_worklet_group_effect_.Get());
  }
}

NOTREACHED();
}

void V8UnionWorkletAnimationEffectOrWorkletGroupEffect::Trace(Visitor* visitor) const {
  visitor->Trace(member_worklet_animation_effect_);
visitor->Trace(member_worklet_group_effect_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionWorkletAnimationEffectOrWorkletGroupEffect::Clear() {
  member_worklet_animation_effect_.Clear();
member_worklet_group_effect_.Clear();
}



}  // namespace blink
