// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_routerrule_routerrulesequence.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_router_rule.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionRouterRuleOrRouterRuleSequence* V8UnionRouterRuleOrRouterRuleSequence::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = RouterRule::Create(isolate);
return MakeGarbageCollected<V8UnionRouterRuleOrRouterRuleSequence>(blink_value);
}
if (v8_value->IsArray()) {
  auto&& blink_value = NativeValueTraits<IDLSequence<RouterRule>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionRouterRuleOrRouterRuleSequence>(std::move(blink_value));
}
if (v8_value->IsObject()) {
  ScriptIterator script_iterator = ScriptIterator::FromIterable(isolate, v8_value.As<v8::Object>(), exception_state, ScriptIterator::Kind::kSync);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
if (!script_iterator.IsNull()) {
  auto&& blink_value = bindings::CreateIDLSequenceFromIterator<RouterRule>(isolate, std::move(script_iterator), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionRouterRuleOrRouterRuleSequence>(std::move(blink_value));
}
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<RouterRule>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionRouterRuleOrRouterRuleSequence>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}

 V8UnionRouterRuleOrRouterRuleSequence::V8UnionRouterRuleOrRouterRuleSequence(const HeapVector<Member<RouterRule>>& value) : content_type_(ContentType::kRouterRuleSequence), member_router_rule_sequence_(value) {
  
}

 V8UnionRouterRuleOrRouterRuleSequence::V8UnionRouterRuleOrRouterRuleSequence(HeapVector<Member<RouterRule>>&& value) : content_type_(ContentType::kRouterRuleSequence), member_router_rule_sequence_(std::move(value)) {
  
}







void V8UnionRouterRuleOrRouterRuleSequence::Set(const HeapVector<Member<RouterRule>>& value) {
  Clear();
member_router_rule_sequence_ = value;
content_type_ = ContentType::kRouterRuleSequence;
}

void V8UnionRouterRuleOrRouterRuleSequence::Set(HeapVector<Member<RouterRule>>&& value) {
  Clear();
member_router_rule_sequence_ = std::move(value);
content_type_ = ContentType::kRouterRuleSequence;
}


void V8UnionRouterRuleOrRouterRuleSequence::Trace(Visitor* visitor) const {
  visitor->Trace(member_router_rule_);
visitor->Trace(member_router_rule_sequence_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionRouterRuleOrRouterRuleSequence::Clear() {
  member_router_rule_.Clear();
member_router_rule_sequence_.clear();
}



}  // namespace blink
