// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_mediastreamtrackaudiostats_mediastreamtrackvideostats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_stream_track_audio_stats.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_stream_track_video_stats.h"
#include "third_party/blink/renderer/modules/mediastream/media_stream_track_audio_stats.h"
#include "third_party/blink/renderer/modules/mediastream/media_stream_track_video_stats.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats* V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8MediaStreamTrackVideoStats::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8MediaStreamTrackVideoStats::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats>(blink_value);
}
if (V8MediaStreamTrackAudioStats::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8MediaStreamTrackAudioStats::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kMediaStreamTrackAudioStats: {
    return ToV8Traits<MediaStreamTrackAudioStats>::ToV8(script_state, member_media_stream_track_audio_stats_.Get());
  }
  case ContentType::kMediaStreamTrackVideoStats: {
    return ToV8Traits<MediaStreamTrackVideoStats>::ToV8(script_state, member_media_stream_track_video_stats_.Get());
  }
}

NOTREACHED();
}

void V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats::Trace(Visitor* visitor) const {
  visitor->Trace(member_media_stream_track_audio_stats_);
visitor->Trace(member_media_stream_track_video_stats_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionMediaStreamTrackAudioStatsOrMediaStreamTrackVideoStats::Clear() {
  member_media_stream_track_audio_stats_.Clear();
member_media_stream_track_video_stats_.Clear();
}



}  // namespace blink
