// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_mediasourcehandle_mediastream.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_source_handle.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_stream.h"
#include "third_party/blink/renderer/modules/mediasource/media_source_handle_impl.h"
#include "third_party/blink/renderer/modules/mediastream/media_stream.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionMediaSourceHandleOrMediaStream* V8UnionMediaSourceHandleOrMediaStream::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8MediaStream::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8MediaStream::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionMediaSourceHandleOrMediaStream>(blink_value);
}
if (V8MediaSourceHandle::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8MediaSourceHandle::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionMediaSourceHandleOrMediaStream>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










v8::Local<v8::Value> V8UnionMediaSourceHandleOrMediaStream::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kMediaSourceHandle: {
    return ToV8Traits<MediaSourceHandleImpl>::ToV8(script_state, member_media_source_handle_.Get());
  }
  case ContentType::kMediaStream: {
    return ToV8Traits<MediaStream>::ToV8(script_state, member_media_stream_.Get());
  }
}

NOTREACHED();
}

void V8UnionMediaSourceHandleOrMediaStream::Trace(Visitor* visitor) const {
  visitor->Trace(member_media_source_handle_);
visitor->Trace(member_media_stream_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionMediaSourceHandleOrMediaStream::Clear() {
  member_media_source_handle_.Clear();
member_media_stream_.Clear();
}



}  // namespace blink
