// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_MEDIAKEYSTATUS_UNDEFINED_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_MEDIAKEYSTATUS_UNDEFINED_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_media_key_status.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"

namespace blink {

class ExceptionState;
class ScriptState;

class MODULES_EXPORT V8UnionMediaKeyStatusOrUndefined final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kMediaKeyStatus, kUndefined
};

static V8UnionMediaKeyStatusOrUndefined* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionMediaKeyStatusOrUndefined(V8MediaKeyStatus value) : content_type_(ContentType::kMediaKeyStatus), member_media_key_status_(value) {
  
}
explicit  V8UnionMediaKeyStatusOrUndefined(const ToV8UndefinedGenerator& value) : content_type_(ContentType::kUndefined), member_undefined_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsMediaKeyStatus() const {
  return content_type_ == ContentType::kMediaKeyStatus;
}
V8MediaKeyStatus GetAsMediaKeyStatus() const {
  DCHECK_EQ(content_type_, ContentType::kMediaKeyStatus);
return member_media_key_status_;
}
void Set(V8MediaKeyStatus value) {
  Clear();
member_media_key_status_ = value;
content_type_ = ContentType::kMediaKeyStatus;
}

bool IsUndefined() const {
  return content_type_ == ContentType::kUndefined;
}
const ToV8UndefinedGenerator& GetAsUndefined() const {
  DCHECK_EQ(content_type_, ContentType::kUndefined);
return member_undefined_;
}
void Set(const ToV8UndefinedGenerator& value) {
  Clear();
member_undefined_ = value;
content_type_ = ContentType::kUndefined;
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(MediaKeyStatus or undefined)";
}

ContentType content_type_;

V8MediaKeyStatus member_media_key_status_{static_cast<V8MediaKeyStatus::Enum>(0)};
ToV8UndefinedGenerator member_undefined_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_MEDIAKEYSTATUS_UNDEFINED_H_
