// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_LANGUAGE_MODEL_MESSAGE_VALUE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_LANGUAGE_MODEL_MESSAGE_VALUE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AudioBuffer;
class Blob;
class ExceptionState;
class HTMLAudioElement;
class HTMLCanvasElement;
class HTMLImageElement;
class HTMLVideoElement;
class ImageBitmap;
class ImageData;
class LanguageModelToolCall;
class LanguageModelToolError;
class LanguageModelToolSuccess;
class OffscreenCanvas;
class SVGImageElement;
class ScriptState;
class V8UnionArrayBufferOrArrayBufferView;
class V8UnionArrayBufferOrArrayBufferViewOrString;
class V8UnionArrayBufferOrString;
class V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame;
class V8UnionBlobOrString;
class V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame;
class V8UnionHTMLCanvasElementOrOffscreenCanvas;
class V8UnionHTMLVideoElementOrVideoFrame;
class V8UnionLanguageModelToolErrorOrLanguageModelToolSuccess;
class VideoFrame;

class MODULES_EXPORT V8LanguageModelMessageValue final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kArrayBuffer, kArrayBufferView, kAudioBuffer, kBlob, kHTMLAudioElement, kHTMLCanvasElement, kHTMLImageElement, kHTMLVideoElement, kImageBitmap, kImageData, kLanguageModelToolCall, kLanguageModelToolError, kLanguageModelToolSuccess, kOffscreenCanvas, kSVGImageElement, kString, kVideoFrame
};

static V8LanguageModelMessageValue* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8LanguageModelMessageValue(DOMArrayBuffer* value) : content_type_(ContentType::kArrayBuffer), member_array_buffer_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(NotShared<DOMArrayBufferView> value) : content_type_(ContentType::kArrayBufferView), member_array_buffer_view_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(AudioBuffer* value) : content_type_(ContentType::kAudioBuffer), member_audio_buffer_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(Blob* value) : content_type_(ContentType::kBlob), member_blob_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(HTMLAudioElement* value) : content_type_(ContentType::kHTMLAudioElement), member_html_audio_element_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(HTMLCanvasElement* value) : content_type_(ContentType::kHTMLCanvasElement), member_html_canvas_element_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(HTMLImageElement* value) : content_type_(ContentType::kHTMLImageElement), member_html_image_element_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(HTMLVideoElement* value) : content_type_(ContentType::kHTMLVideoElement), member_html_video_element_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(ImageBitmap* value) : content_type_(ContentType::kImageBitmap), member_image_bitmap_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(ImageData* value) : content_type_(ContentType::kImageData), member_image_data_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(LanguageModelToolCall* value) : content_type_(ContentType::kLanguageModelToolCall), member_language_model_tool_call_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(LanguageModelToolError* value) : content_type_(ContentType::kLanguageModelToolError), member_language_model_tool_error_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(LanguageModelToolSuccess* value) : content_type_(ContentType::kLanguageModelToolSuccess), member_language_model_tool_success_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(OffscreenCanvas* value) : content_type_(ContentType::kOffscreenCanvas), member_offscreen_canvas_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(SVGImageElement* value) : content_type_(ContentType::kSVGImageElement), member_svg_image_element_(value) {
  DCHECK(value);
}
explicit  V8LanguageModelMessageValue(const String& value);
explicit  V8LanguageModelMessageValue(String&& value);
explicit  V8LanguageModelMessageValue(VideoFrame* value) : content_type_(ContentType::kVideoFrame), member_video_frame_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsArrayBuffer() const {
  return content_type_ == ContentType::kArrayBuffer;
}
DOMArrayBuffer* GetAsArrayBuffer() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBuffer);
return member_array_buffer_.Get();
}
void Set(DOMArrayBuffer* value) {
  DCHECK(value);
Clear();
member_array_buffer_ = value;
content_type_ = ContentType::kArrayBuffer;
}

bool IsArrayBufferView() const {
  return content_type_ == ContentType::kArrayBufferView;
}
NotShared<DOMArrayBufferView> GetAsArrayBufferView() const {
  DCHECK_EQ(content_type_, ContentType::kArrayBufferView);
return member_array_buffer_view_;
}
void Set(NotShared<DOMArrayBufferView> value) {
  DCHECK(value);
Clear();
member_array_buffer_view_ = value;
content_type_ = ContentType::kArrayBufferView;
}

bool IsAudioBuffer() const {
  return content_type_ == ContentType::kAudioBuffer;
}
AudioBuffer* GetAsAudioBuffer() const {
  DCHECK_EQ(content_type_, ContentType::kAudioBuffer);
return member_audio_buffer_.Get();
}
void Set(AudioBuffer* value) {
  DCHECK(value);
Clear();
member_audio_buffer_ = value;
content_type_ = ContentType::kAudioBuffer;
}

bool IsBlob() const {
  return content_type_ == ContentType::kBlob;
}
Blob* GetAsBlob() const {
  DCHECK_EQ(content_type_, ContentType::kBlob);
return member_blob_.Get();
}
void Set(Blob* value) {
  DCHECK(value);
Clear();
member_blob_ = value;
content_type_ = ContentType::kBlob;
}

bool IsHTMLAudioElement() const {
  return content_type_ == ContentType::kHTMLAudioElement;
}
HTMLAudioElement* GetAsHTMLAudioElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLAudioElement);
return member_html_audio_element_.Get();
}
void Set(HTMLAudioElement* value) {
  DCHECK(value);
Clear();
member_html_audio_element_ = value;
content_type_ = ContentType::kHTMLAudioElement;
}

bool IsHTMLCanvasElement() const {
  return content_type_ == ContentType::kHTMLCanvasElement;
}
HTMLCanvasElement* GetAsHTMLCanvasElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLCanvasElement);
return member_html_canvas_element_.Get();
}
void Set(HTMLCanvasElement* value) {
  DCHECK(value);
Clear();
member_html_canvas_element_ = value;
content_type_ = ContentType::kHTMLCanvasElement;
}

bool IsHTMLImageElement() const {
  return content_type_ == ContentType::kHTMLImageElement;
}
HTMLImageElement* GetAsHTMLImageElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLImageElement);
return member_html_image_element_.Get();
}
void Set(HTMLImageElement* value) {
  DCHECK(value);
Clear();
member_html_image_element_ = value;
content_type_ = ContentType::kHTMLImageElement;
}

bool IsHTMLVideoElement() const {
  return content_type_ == ContentType::kHTMLVideoElement;
}
HTMLVideoElement* GetAsHTMLVideoElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLVideoElement);
return member_html_video_element_.Get();
}
void Set(HTMLVideoElement* value) {
  DCHECK(value);
Clear();
member_html_video_element_ = value;
content_type_ = ContentType::kHTMLVideoElement;
}

bool IsImageBitmap() const {
  return content_type_ == ContentType::kImageBitmap;
}
ImageBitmap* GetAsImageBitmap() const {
  DCHECK_EQ(content_type_, ContentType::kImageBitmap);
return member_image_bitmap_.Get();
}
void Set(ImageBitmap* value) {
  DCHECK(value);
Clear();
member_image_bitmap_ = value;
content_type_ = ContentType::kImageBitmap;
}

bool IsImageData() const {
  return content_type_ == ContentType::kImageData;
}
ImageData* GetAsImageData() const {
  DCHECK_EQ(content_type_, ContentType::kImageData);
return member_image_data_.Get();
}
void Set(ImageData* value) {
  DCHECK(value);
Clear();
member_image_data_ = value;
content_type_ = ContentType::kImageData;
}

bool IsLanguageModelToolCall() const {
  return content_type_ == ContentType::kLanguageModelToolCall;
}
LanguageModelToolCall* GetAsLanguageModelToolCall() const {
  DCHECK_EQ(content_type_, ContentType::kLanguageModelToolCall);
return member_language_model_tool_call_.Get();
}
void Set(LanguageModelToolCall* value) {
  DCHECK(value);
Clear();
member_language_model_tool_call_ = value;
content_type_ = ContentType::kLanguageModelToolCall;
}

bool IsLanguageModelToolError() const {
  return content_type_ == ContentType::kLanguageModelToolError;
}
LanguageModelToolError* GetAsLanguageModelToolError() const {
  DCHECK_EQ(content_type_, ContentType::kLanguageModelToolError);
return member_language_model_tool_error_.Get();
}
void Set(LanguageModelToolError* value) {
  DCHECK(value);
Clear();
member_language_model_tool_error_ = value;
content_type_ = ContentType::kLanguageModelToolError;
}

bool IsLanguageModelToolSuccess() const {
  return content_type_ == ContentType::kLanguageModelToolSuccess;
}
LanguageModelToolSuccess* GetAsLanguageModelToolSuccess() const {
  DCHECK_EQ(content_type_, ContentType::kLanguageModelToolSuccess);
return member_language_model_tool_success_.Get();
}
void Set(LanguageModelToolSuccess* value) {
  DCHECK(value);
Clear();
member_language_model_tool_success_ = value;
content_type_ = ContentType::kLanguageModelToolSuccess;
}

bool IsOffscreenCanvas() const {
  return content_type_ == ContentType::kOffscreenCanvas;
}
OffscreenCanvas* GetAsOffscreenCanvas() const {
  DCHECK_EQ(content_type_, ContentType::kOffscreenCanvas);
return member_offscreen_canvas_.Get();
}
void Set(OffscreenCanvas* value) {
  DCHECK(value);
Clear();
member_offscreen_canvas_ = value;
content_type_ = ContentType::kOffscreenCanvas;
}

bool IsSVGImageElement() const {
  return content_type_ == ContentType::kSVGImageElement;
}
SVGImageElement* GetAsSVGImageElement() const {
  DCHECK_EQ(content_type_, ContentType::kSVGImageElement);
return member_svg_image_element_.Get();
}
void Set(SVGImageElement* value) {
  DCHECK(value);
Clear();
member_svg_image_element_ = value;
content_type_ = ContentType::kSVGImageElement;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);

bool IsVideoFrame() const {
  return content_type_ == ContentType::kVideoFrame;
}
VideoFrame* GetAsVideoFrame() const {
  DCHECK_EQ(content_type_, ContentType::kVideoFrame);
return member_video_frame_.Get();
}
void Set(VideoFrame* value) {
  DCHECK(value);
Clear();
member_video_frame_ = value;
content_type_ = ContentType::kVideoFrame;
}

bool IsV8UnionArrayBufferOrArrayBufferView() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kArrayBufferView;
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8UnionArrayBufferOrArrayBufferView() const;
void Set(const V8UnionArrayBufferOrArrayBufferView* value);
bool IsV8BinaryData() const {
  return IsV8UnionArrayBufferOrArrayBufferView();
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8BinaryData() const {
  return GetAsV8UnionArrayBufferOrArrayBufferView();
}
bool IsV8BufferSource() const {
  return IsV8UnionArrayBufferOrArrayBufferView();
}
V8UnionArrayBufferOrArrayBufferView* GetAsV8BufferSource() const {
  return GetAsV8UnionArrayBufferOrArrayBufferView();
}

bool IsV8UnionArrayBufferOrArrayBufferViewOrString() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kArrayBufferView || content_type_ == ContentType::kString;
}
V8UnionArrayBufferOrArrayBufferViewOrString* GetAsV8UnionArrayBufferOrArrayBufferViewOrString() const;
void Set(const V8UnionArrayBufferOrArrayBufferViewOrString* value);

bool IsV8UnionArrayBufferOrString() const {
  return content_type_ == ContentType::kArrayBuffer || content_type_ == ContentType::kString;
}
V8UnionArrayBufferOrString* GetAsV8UnionArrayBufferOrString() const;
void Set(const V8UnionArrayBufferOrString* value);

bool IsV8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame() const {
  return content_type_ == ContentType::kBlob || content_type_ == ContentType::kHTMLCanvasElement || content_type_ == ContentType::kHTMLImageElement || content_type_ == ContentType::kHTMLVideoElement || content_type_ == ContentType::kImageBitmap || content_type_ == ContentType::kImageData || content_type_ == ContentType::kOffscreenCanvas || content_type_ == ContentType::kSVGImageElement || content_type_ == ContentType::kVideoFrame;
}
V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame* GetAsV8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame() const;
void Set(const V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame* value);
bool IsV8ImageBitmapSource() const {
  return IsV8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame();
}
V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame* GetAsV8ImageBitmapSource() const {
  return GetAsV8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame();
}

bool IsV8UnionBlobOrString() const {
  return content_type_ == ContentType::kBlob || content_type_ == ContentType::kString;
}
V8UnionBlobOrString* GetAsV8UnionBlobOrString() const;
void Set(const V8UnionBlobOrString* value);

bool IsV8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame() const {
  return content_type_ == ContentType::kHTMLCanvasElement || content_type_ == ContentType::kHTMLImageElement || content_type_ == ContentType::kHTMLVideoElement || content_type_ == ContentType::kImageBitmap || content_type_ == ContentType::kImageData || content_type_ == ContentType::kOffscreenCanvas || content_type_ == ContentType::kVideoFrame;
}
V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* GetAsV8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame() const;
void Set(const V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* value);
bool IsV8GPUImageCopyExternalImageSource() const {
  return IsV8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame();
}
V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* GetAsV8GPUImageCopyExternalImageSource() const {
  return GetAsV8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame();
}

bool IsV8UnionHTMLCanvasElementOrOffscreenCanvas() const {
  return content_type_ == ContentType::kHTMLCanvasElement || content_type_ == ContentType::kOffscreenCanvas;
}
V8UnionHTMLCanvasElementOrOffscreenCanvas* GetAsV8UnionHTMLCanvasElementOrOffscreenCanvas() const;
void Set(const V8UnionHTMLCanvasElementOrOffscreenCanvas* value);

bool IsV8UnionHTMLVideoElementOrVideoFrame() const {
  return content_type_ == ContentType::kHTMLVideoElement || content_type_ == ContentType::kVideoFrame;
}
V8UnionHTMLVideoElementOrVideoFrame* GetAsV8UnionHTMLVideoElementOrVideoFrame() const;
void Set(const V8UnionHTMLVideoElementOrVideoFrame* value);

bool IsV8UnionLanguageModelToolErrorOrLanguageModelToolSuccess() const {
  return content_type_ == ContentType::kLanguageModelToolError || content_type_ == ContentType::kLanguageModelToolSuccess;
}
V8UnionLanguageModelToolErrorOrLanguageModelToolSuccess* GetAsV8UnionLanguageModelToolErrorOrLanguageModelToolSuccess() const;
void Set(const V8UnionLanguageModelToolErrorOrLanguageModelToolSuccess* value);
bool IsV8LanguageModelToolResponse() const {
  return IsV8UnionLanguageModelToolErrorOrLanguageModelToolSuccess();
}
V8UnionLanguageModelToolErrorOrLanguageModelToolSuccess* GetAsV8LanguageModelToolResponse() const {
  return GetAsV8UnionLanguageModelToolErrorOrLanguageModelToolSuccess();
}


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(ArrayBuffer or ArrayBufferView or AudioBuffer or Blob or DOMString or HTMLAudioElement or HTMLCanvasElement or HTMLImageElement or HTMLVideoElement or ImageBitmap or ImageData or LanguageModelToolCall or LanguageModelToolError or LanguageModelToolSuccess or OffscreenCanvas or SVGImageElement or VideoFrame)";
}

ContentType content_type_;

Member<DOMArrayBuffer> member_array_buffer_;
NotShared<DOMArrayBufferView> member_array_buffer_view_;
Member<AudioBuffer> member_audio_buffer_;
Member<Blob> member_blob_;
Member<HTMLAudioElement> member_html_audio_element_;
Member<HTMLCanvasElement> member_html_canvas_element_;
Member<HTMLImageElement> member_html_image_element_;
Member<HTMLVideoElement> member_html_video_element_;
Member<ImageBitmap> member_image_bitmap_;
Member<ImageData> member_image_data_;
Member<LanguageModelToolCall> member_language_model_tool_call_;
Member<LanguageModelToolError> member_language_model_tool_error_;
Member<LanguageModelToolSuccess> member_language_model_tool_success_;
Member<OffscreenCanvas> member_offscreen_canvas_;
Member<SVGImageElement> member_svg_image_element_;
String member_string_;
Member<VideoFrame> member_video_frame_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_LANGUAGE_MODEL_MESSAGE_VALUE_H_
