// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_identityprovidertoken_usvstring.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_identity_provider_token.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionIdentityProviderTokenOrUSVString* V8UnionIdentityProviderTokenOrUSVString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = NativeValueTraits<IdentityProviderToken>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionIdentityProviderTokenOrUSVString>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<IdentityProviderToken>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionIdentityProviderTokenOrUSVString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLUSVString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionIdentityProviderTokenOrUSVString>(std::move(blink_value));
}
}

 V8UnionIdentityProviderTokenOrUSVString::V8UnionIdentityProviderTokenOrUSVString(const String& value) : content_type_(ContentType::kUSVString), member_usv_string_(value) {
  
}

 V8UnionIdentityProviderTokenOrUSVString::V8UnionIdentityProviderTokenOrUSVString(String&& value) : content_type_(ContentType::kUSVString), member_usv_string_(std::move(value)) {
  
}







void V8UnionIdentityProviderTokenOrUSVString::Set(const String& value) {
  Clear();
member_usv_string_ = value;
content_type_ = ContentType::kUSVString;
}

void V8UnionIdentityProviderTokenOrUSVString::Set(String&& value) {
  Clear();
member_usv_string_ = std::move(value);
content_type_ = ContentType::kUSVString;
}


void V8UnionIdentityProviderTokenOrUSVString::Trace(Visitor* visitor) const {
  visitor->Trace(member_identity_provider_token_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionIdentityProviderTokenOrUSVString::Clear() {
  member_identity_provider_token_.Clear();
member_usv_string_ = String();
}



}  // namespace blink
