// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_HTMLFORMELEMENT_PASSWORDCREDENTIALDATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_HTMLFORMELEMENT_PASSWORDCREDENTIALDATA_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class HTMLFormElement;
class PasswordCredentialData;
class ScriptState;

class MODULES_EXPORT V8UnionHTMLFormElementOrPasswordCredentialData final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kHTMLFormElement, kPasswordCredentialData
};

static V8UnionHTMLFormElementOrPasswordCredentialData* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionHTMLFormElementOrPasswordCredentialData(HTMLFormElement* value) : content_type_(ContentType::kHTMLFormElement), member_html_form_element_(value) {
  DCHECK(value);
}
explicit  V8UnionHTMLFormElementOrPasswordCredentialData(PasswordCredentialData* value) : content_type_(ContentType::kPasswordCredentialData), member_password_credential_data_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsHTMLFormElement() const {
  return content_type_ == ContentType::kHTMLFormElement;
}
HTMLFormElement* GetAsHTMLFormElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLFormElement);
return member_html_form_element_.Get();
}
void Set(HTMLFormElement* value) {
  DCHECK(value);
Clear();
member_html_form_element_ = value;
content_type_ = ContentType::kHTMLFormElement;
}

bool IsPasswordCredentialData() const {
  return content_type_ == ContentType::kPasswordCredentialData;
}
PasswordCredentialData* GetAsPasswordCredentialData() const {
  DCHECK_EQ(content_type_, ContentType::kPasswordCredentialData);
return member_password_credential_data_.Get();
}
void Set(PasswordCredentialData* value) {
  DCHECK(value);
Clear();
member_password_credential_data_ = value;
content_type_ = ContentType::kPasswordCredentialData;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(HTMLFormElement or PasswordCredentialData)";
}

ContentType content_type_;

Member<HTMLFormElement> member_html_form_element_;
Member<PasswordCredentialData> member_password_credential_data_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_HTMLFORMELEMENT_PASSWORDCREDENTIALDATA_H_
