// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_htmlformelement_passwordcredentialdata.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_form_element.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_password_credential_data.h"
#include "third_party/blink/renderer/core/html/forms/html_form_element.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionHTMLFormElementOrPasswordCredentialData* V8UnionHTMLFormElementOrPasswordCredentialData::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = NativeValueTraits<PasswordCredentialData>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionHTMLFormElementOrPasswordCredentialData>(blink_value);
}
if (V8HTMLFormElement::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8HTMLFormElement::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionHTMLFormElementOrPasswordCredentialData>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<PasswordCredentialData>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionHTMLFormElementOrPasswordCredentialData>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










void V8UnionHTMLFormElementOrPasswordCredentialData::Trace(Visitor* visitor) const {
  visitor->Trace(member_html_form_element_);
visitor->Trace(member_password_credential_data_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionHTMLFormElementOrPasswordCredentialData::Clear() {
  member_html_form_element_.Clear();
member_password_credential_data_.Clear();
}



}  // namespace blink
