// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_GPUTEXTURE_GPUTEXTUREVIEW_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_GPUTEXTURE_GPUTEXTUREVIEW_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUTexture;
class GPUTextureView;
class ScriptState;

class MODULES_EXPORT V8UnionGPUTextureOrGPUTextureView final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kGPUTexture, kGPUTextureView
};

static V8UnionGPUTextureOrGPUTextureView* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionGPUTextureOrGPUTextureView(GPUTexture* value) : content_type_(ContentType::kGPUTexture), member_gpu_texture_(value) {
  DCHECK(value);
}
explicit  V8UnionGPUTextureOrGPUTextureView(GPUTextureView* value) : content_type_(ContentType::kGPUTextureView), member_gpu_texture_view_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsGPUTexture() const {
  return content_type_ == ContentType::kGPUTexture;
}
GPUTexture* GetAsGPUTexture() const {
  DCHECK_EQ(content_type_, ContentType::kGPUTexture);
return member_gpu_texture_.Get();
}
void Set(GPUTexture* value) {
  DCHECK(value);
Clear();
member_gpu_texture_ = value;
content_type_ = ContentType::kGPUTexture;
}

bool IsGPUTextureView() const {
  return content_type_ == ContentType::kGPUTextureView;
}
GPUTextureView* GetAsGPUTextureView() const {
  DCHECK_EQ(content_type_, ContentType::kGPUTextureView);
return member_gpu_texture_view_.Get();
}
void Set(GPUTextureView* value) {
  DCHECK(value);
Clear();
member_gpu_texture_view_ = value;
content_type_ = ContentType::kGPUTextureView;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(GPUTexture or GPUTextureView)";
}

ContentType content_type_;

Member<GPUTexture> member_gpu_texture_;
Member<GPUTextureView> member_gpu_texture_view_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_GPUTEXTURE_GPUTEXTUREVIEW_H_
