// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_gpubuffer_gpubufferbinding_gpuexternaltexture_gpusampler_gputexture_gputextureview.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer_binding.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_external_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_sampler.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_texture_view.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_union_gputexture_gputextureview.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_buffer.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_external_texture.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_sampler.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_texture.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_texture_view.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView* V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = NativeValueTraits<GPUBufferBinding>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView>(blink_value);
}
if (V8GPUTextureView::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8GPUTextureView::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView>(blink_value);
}
if (V8GPUTexture::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8GPUTexture::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView>(blink_value);
}
if (V8GPUSampler::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8GPUSampler::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView>(blink_value);
}
if (V8GPUExternalTexture::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8GPUExternalTexture::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView>(blink_value);
}
if (V8GPUBuffer::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8GPUBuffer::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<GPUBufferBinding>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}






















V8UnionGPUTextureOrGPUTextureView* V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView::GetAsV8UnionGPUTextureOrGPUTextureView() const {
  switch (content_type_) {
  case ContentType::kGPUTexture: {
    return MakeGarbageCollected<V8UnionGPUTextureOrGPUTextureView>(GetAsGPUTexture());
  }
  case ContentType::kGPUTextureView: {
    return MakeGarbageCollected<V8UnionGPUTextureOrGPUTextureView>(GetAsGPUTextureView());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView::Set(const V8UnionGPUTextureOrGPUTextureView* value) {
  switch (value->GetContentType()) {
  case V8UnionGPUTextureOrGPUTextureView::ContentType::kGPUTexture: {
    Set(value->GetAsGPUTexture());
    break;
  }
  case V8UnionGPUTextureOrGPUTextureView::ContentType::kGPUTextureView: {
    Set(value->GetAsGPUTextureView());
    break;
  }
}
}


void V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView::Trace(Visitor* visitor) const {
  visitor->Trace(member_gpu_buffer_);
visitor->Trace(member_gpu_buffer_binding_);
visitor->Trace(member_gpu_external_texture_);
visitor->Trace(member_gpu_sampler_);
visitor->Trace(member_gpu_texture_);
visitor->Trace(member_gpu_texture_view_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionGPUBufferOrGPUBufferBindingOrGPUExternalTextureOrGPUSamplerOrGPUTextureOrGPUTextureView::Clear() {
  member_gpu_buffer_.Clear();
member_gpu_buffer_binding_.Clear();
member_gpu_external_texture_.Clear();
member_gpu_sampler_.Clear();
member_gpu_texture_.Clear();
member_gpu_texture_view_.Clear();
}



}  // namespace blink
