// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_GPUAUTOLAYOUTMODE_GPUPIPELINELAYOUT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_GPUAUTOLAYOUTMODE_GPUPIPELINELAYOUT_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_auto_layout_mode.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class GPUPipelineLayout;
class ScriptState;

class MODULES_EXPORT V8UnionGPUAutoLayoutModeOrGPUPipelineLayout final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kGPUAutoLayoutMode, kGPUPipelineLayout
};

static V8UnionGPUAutoLayoutModeOrGPUPipelineLayout* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionGPUAutoLayoutModeOrGPUPipelineLayout(V8GPUAutoLayoutMode value) : content_type_(ContentType::kGPUAutoLayoutMode), member_gpu_auto_layout_mode_(value) {
  
}
explicit  V8UnionGPUAutoLayoutModeOrGPUPipelineLayout(GPUPipelineLayout* value) : content_type_(ContentType::kGPUPipelineLayout), member_gpu_pipeline_layout_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsGPUAutoLayoutMode() const {
  return content_type_ == ContentType::kGPUAutoLayoutMode;
}
V8GPUAutoLayoutMode GetAsGPUAutoLayoutMode() const {
  DCHECK_EQ(content_type_, ContentType::kGPUAutoLayoutMode);
return member_gpu_auto_layout_mode_;
}
void Set(V8GPUAutoLayoutMode value) {
  Clear();
member_gpu_auto_layout_mode_ = value;
content_type_ = ContentType::kGPUAutoLayoutMode;
}

bool IsGPUPipelineLayout() const {
  return content_type_ == ContentType::kGPUPipelineLayout;
}
GPUPipelineLayout* GetAsGPUPipelineLayout() const {
  DCHECK_EQ(content_type_, ContentType::kGPUPipelineLayout);
return member_gpu_pipeline_layout_.Get();
}
void Set(GPUPipelineLayout* value) {
  DCHECK(value);
Clear();
member_gpu_pipeline_layout_ = value;
content_type_ = ContentType::kGPUPipelineLayout;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(GPUAutoLayoutMode or GPUPipelineLayout)";
}

ContentType content_type_;

V8GPUAutoLayoutMode member_gpu_auto_layout_mode_{static_cast<V8GPUAutoLayoutMode::Enum>(0)};
Member<GPUPipelineLayout> member_gpu_pipeline_layout_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_GPUAUTOLAYOUTMODE_GPUPIPELINELAYOUT_H_
