// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_FILESYSTEMHANDLE_WELLKNOWNDIRECTORY_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_FILESYSTEMHANDLE_WELLKNOWNDIRECTORY_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_well_known_directory.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class FileSystemHandle;
class ScriptState;

class MODULES_EXPORT V8UnionFileSystemHandleOrWellKnownDirectory final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kFileSystemHandle, kWellKnownDirectory
};

static V8UnionFileSystemHandleOrWellKnownDirectory* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionFileSystemHandleOrWellKnownDirectory(FileSystemHandle* value) : content_type_(ContentType::kFileSystemHandle), member_file_system_handle_(value) {
  DCHECK(value);
}
explicit  V8UnionFileSystemHandleOrWellKnownDirectory(V8WellKnownDirectory value) : content_type_(ContentType::kWellKnownDirectory), member_well_known_directory_(value) {
  
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsFileSystemHandle() const {
  return content_type_ == ContentType::kFileSystemHandle;
}
FileSystemHandle* GetAsFileSystemHandle() const {
  DCHECK_EQ(content_type_, ContentType::kFileSystemHandle);
return member_file_system_handle_.Get();
}
void Set(FileSystemHandle* value) {
  DCHECK(value);
Clear();
member_file_system_handle_ = value;
content_type_ = ContentType::kFileSystemHandle;
}

bool IsWellKnownDirectory() const {
  return content_type_ == ContentType::kWellKnownDirectory;
}
V8WellKnownDirectory GetAsWellKnownDirectory() const {
  DCHECK_EQ(content_type_, ContentType::kWellKnownDirectory);
return member_well_known_directory_;
}
void Set(V8WellKnownDirectory value) {
  Clear();
member_well_known_directory_ = value;
content_type_ = ContentType::kWellKnownDirectory;
}


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(FileSystemHandle or WellKnownDirectory)";
}

ContentType content_type_;

Member<FileSystemHandle> member_file_system_handle_;
V8WellKnownDirectory member_well_known_directory_{static_cast<V8WellKnownDirectory::Enum>(0)};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_FILESYSTEMHANDLE_WELLKNOWNDIRECTORY_H_
