// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_doublesequence_gpucolordict.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_color_dict.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionDoubleSequenceOrGPUColorDict* V8UnionDoubleSequenceOrGPUColorDict::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = NativeValueTraits<GPUColorDict>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleSequenceOrGPUColorDict>(blink_value);
}
if (v8_value->IsArray()) {
  auto&& blink_value = NativeValueTraits<IDLSequence<IDLDouble>>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleSequenceOrGPUColorDict>(std::move(blink_value));
}
if (v8_value->IsObject()) {
  ScriptIterator script_iterator = ScriptIterator::FromIterable(isolate, v8_value.As<v8::Object>(), exception_state, ScriptIterator::Kind::kSync);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
if (!script_iterator.IsNull()) {
  auto&& blink_value = bindings::CreateIDLSequenceFromIterator<IDLDouble>(isolate, std::move(script_iterator), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleSequenceOrGPUColorDict>(std::move(blink_value));
}
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<GPUColorDict>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionDoubleSequenceOrGPUColorDict>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}

 V8UnionDoubleSequenceOrGPUColorDict::V8UnionDoubleSequenceOrGPUColorDict(const Vector<double>& value) : content_type_(ContentType::kDoubleSequence), member_double_sequence_(value) {
  
}

 V8UnionDoubleSequenceOrGPUColorDict::V8UnionDoubleSequenceOrGPUColorDict(Vector<double>&& value) : content_type_(ContentType::kDoubleSequence), member_double_sequence_(std::move(value)) {
  
}




void V8UnionDoubleSequenceOrGPUColorDict::Set(const Vector<double>& value) {
  Clear();
member_double_sequence_ = value;
content_type_ = ContentType::kDoubleSequence;
}

void V8UnionDoubleSequenceOrGPUColorDict::Set(Vector<double>&& value) {
  Clear();
member_double_sequence_ = std::move(value);
content_type_ = ContentType::kDoubleSequence;
}





void V8UnionDoubleSequenceOrGPUColorDict::Trace(Visitor* visitor) const {
  visitor->Trace(member_gpu_color_dict_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionDoubleSequenceOrGPUColorDict::Clear() {
  member_double_sequence_.clear();
member_gpu_color_dict_.Clear();
}



}  // namespace blink
