// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_client_messageport_serviceworker.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_message_port.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_client.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_service_worker.h"
#include "third_party/blink/renderer/core/messaging/message_port.h"
#include "third_party/blink/renderer/modules/service_worker/service_worker.h"
#include "third_party/blink/renderer/modules/service_worker/service_worker_client.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionClientOrMessagePortOrServiceWorker* V8UnionClientOrMessagePortOrServiceWorker::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8ServiceWorker::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8ServiceWorker::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionClientOrMessagePortOrServiceWorker>(blink_value);
}
if (V8MessagePort::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8MessagePort::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionClientOrMessagePortOrServiceWorker>(blink_value);
}
if (V8Client::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8Client::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionClientOrMessagePortOrServiceWorker>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}













v8::Local<v8::Value> V8UnionClientOrMessagePortOrServiceWorker::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kClient: {
    return ToV8Traits<ServiceWorkerClient>::ToV8(script_state, member_client_.Get());
  }
  case ContentType::kMessagePort: {
    return ToV8Traits<MessagePort>::ToV8(script_state, member_message_port_.Get());
  }
  case ContentType::kServiceWorker: {
    return ToV8Traits<ServiceWorker>::ToV8(script_state, member_service_worker_.Get());
  }
}

NOTREACHED();
}

void V8UnionClientOrMessagePortOrServiceWorker::Trace(Visitor* visitor) const {
  visitor->Trace(member_client_);
visitor->Trace(member_message_port_);
visitor->Trace(member_service_worker_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionClientOrMessagePortOrServiceWorker::Clear() {
  member_client_.Clear();
member_message_port_.Clear();
member_service_worker_.Clear();
}



}  // namespace blink
