// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_canvasfilter_string.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_canvas_filter.h"
#include "third_party/blink/renderer/modules/canvas/canvas2d/canvas_filter.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionCanvasFilterOrString* V8UnionCanvasFilterOrString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8CanvasFilter::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8CanvasFilter::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionCanvasFilterOrString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionCanvasFilterOrString>(std::move(blink_value));
}
}

 V8UnionCanvasFilterOrString::V8UnionCanvasFilterOrString(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionCanvasFilterOrString::V8UnionCanvasFilterOrString(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}







void V8UnionCanvasFilterOrString::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionCanvasFilterOrString::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}


v8::Local<v8::Value> V8UnionCanvasFilterOrString::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kCanvasFilter: {
    return ToV8Traits<CanvasFilter>::ToV8(script_state, member_canvas_filter_.Get());
  }
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
}

NOTREACHED();
}

void V8UnionCanvasFilterOrString::Trace(Visitor* visitor) const {
  visitor->Trace(member_canvas_filter_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionCanvasFilterOrString::Clear() {
  member_canvas_filter_.Clear();
member_string_ = String();
}



}  // namespace blink
