// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_boolean_constrainbooleanordomstringparameters_string.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_boolean_string.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_constrain_boolean_or_dom_string_parameters.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString* V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (v8_value->IsNullOrUndefined()) {
  auto&& blink_value = ConstrainBooleanOrDOMStringParameters::Create(isolate);
return MakeGarbageCollected<V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString>(blink_value);
}
if (v8_value->IsObject()) {
  auto&& blink_value = NativeValueTraits<ConstrainBooleanOrDOMStringParameters>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString>(blink_value);
}
if (v8_value->IsBoolean()) {
  auto&& blink_value = v8_value.As<v8::Boolean>()->Value();
return MakeGarbageCollected<V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString>(blink_value);
}
{
  auto&& blink_value = NativeValueTraits<IDLString>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString>(std::move(blink_value));
}
}

 V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString::V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString(const String& value) : content_type_(ContentType::kString), member_string_(value) {
  
}

 V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString::V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString(String&& value) : content_type_(ContentType::kString), member_string_(std::move(value)) {
  
}










void V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString::Set(const String& value) {
  Clear();
member_string_ = value;
content_type_ = ContentType::kString;
}

void V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString::Set(String&& value) {
  Clear();
member_string_ = std::move(value);
content_type_ = ContentType::kString;
}


V8UnionBooleanOrString* V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString::GetAsV8UnionBooleanOrString() const {
  switch (content_type_) {
  case ContentType::kBoolean: {
    return MakeGarbageCollected<V8UnionBooleanOrString>(GetAsBoolean());
  }
  case ContentType::kString: {
    return MakeGarbageCollected<V8UnionBooleanOrString>(GetAsString());
  }
  default: {
    NOTREACHED();
  }
}
}

void V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString::Set(const V8UnionBooleanOrString* value) {
  switch (value->GetContentType()) {
  case V8UnionBooleanOrString::ContentType::kBoolean: {
    Set(value->GetAsBoolean());
    break;
  }
  case V8UnionBooleanOrString::ContentType::kString: {
    Set(value->GetAsString());
    break;
  }
}
}


v8::Local<v8::Value> V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString::ToV8(ScriptState* script_state) const {
  switch (content_type_) {
  case ContentType::kBoolean: {
    return ToV8Traits<IDLBoolean>::ToV8(script_state, member_boolean_);
  }
  case ContentType::kConstrainBooleanOrDOMStringParameters: {
    return ToV8Traits<ConstrainBooleanOrDOMStringParameters>::ToV8(script_state, member_constrain_boolean_or_dom_string_parameters_.Get());
  }
  case ContentType::kString: {
    return ToV8Traits<IDLString>::ToV8(script_state, member_string_);
  }
}

NOTREACHED();
}

void V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString::Trace(Visitor* visitor) const {
  visitor->Trace(member_constrain_boolean_or_dom_string_parameters_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionBooleanOrConstrainBooleanOrDOMStringParametersOrString::Clear() {
  member_boolean_ = false;
member_constrain_boolean_or_dom_string_parameters_.Clear();
member_string_ = String();
}



}  // namespace blink
