// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_BLOB_HTMLCANVASELEMENT_HTMLIMAGEELEMENT_HTMLVIDEOELEMENT_IMAGEBITMAP_IMAGEDATA_OFFSCREENCANVAS_SVGIMAGEELEMENT_VIDEOFRAME_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_BLOB_HTMLCANVASELEMENT_HTMLIMAGEELEMENT_HTMLVIDEOELEMENT_IMAGEBITMAP_IMAGEDATA_OFFSCREENCANVAS_SVGIMAGEELEMENT_VIDEOFRAME_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class Blob;
class ExceptionState;
class HTMLCanvasElement;
class HTMLImageElement;
class HTMLVideoElement;
class ImageBitmap;
class ImageData;
class OffscreenCanvas;
class SVGImageElement;
class ScriptState;
class V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame;
class V8UnionHTMLCanvasElementOrOffscreenCanvas;
class V8UnionHTMLVideoElementOrVideoFrame;
class VideoFrame;

class MODULES_EXPORT V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kBlob, kHTMLCanvasElement, kHTMLImageElement, kHTMLVideoElement, kImageBitmap, kImageData, kOffscreenCanvas, kSVGImageElement, kVideoFrame
};

static V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame(Blob* value) : content_type_(ContentType::kBlob), member_blob_(value) {
  DCHECK(value);
}
explicit  V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame(HTMLCanvasElement* value) : content_type_(ContentType::kHTMLCanvasElement), member_html_canvas_element_(value) {
  DCHECK(value);
}
explicit  V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame(HTMLImageElement* value) : content_type_(ContentType::kHTMLImageElement), member_html_image_element_(value) {
  DCHECK(value);
}
explicit  V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame(HTMLVideoElement* value) : content_type_(ContentType::kHTMLVideoElement), member_html_video_element_(value) {
  DCHECK(value);
}
explicit  V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame(ImageBitmap* value) : content_type_(ContentType::kImageBitmap), member_image_bitmap_(value) {
  DCHECK(value);
}
explicit  V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame(ImageData* value) : content_type_(ContentType::kImageData), member_image_data_(value) {
  DCHECK(value);
}
explicit  V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame(OffscreenCanvas* value) : content_type_(ContentType::kOffscreenCanvas), member_offscreen_canvas_(value) {
  DCHECK(value);
}
explicit  V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame(SVGImageElement* value) : content_type_(ContentType::kSVGImageElement), member_svg_image_element_(value) {
  DCHECK(value);
}
explicit  V8UnionBlobOrHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrSVGImageElementOrVideoFrame(VideoFrame* value) : content_type_(ContentType::kVideoFrame), member_video_frame_(value) {
  DCHECK(value);
}

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsBlob() const {
  return content_type_ == ContentType::kBlob;
}
Blob* GetAsBlob() const {
  DCHECK_EQ(content_type_, ContentType::kBlob);
return member_blob_.Get();
}
void Set(Blob* value) {
  DCHECK(value);
Clear();
member_blob_ = value;
content_type_ = ContentType::kBlob;
}

bool IsHTMLCanvasElement() const {
  return content_type_ == ContentType::kHTMLCanvasElement;
}
HTMLCanvasElement* GetAsHTMLCanvasElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLCanvasElement);
return member_html_canvas_element_.Get();
}
void Set(HTMLCanvasElement* value) {
  DCHECK(value);
Clear();
member_html_canvas_element_ = value;
content_type_ = ContentType::kHTMLCanvasElement;
}

bool IsHTMLImageElement() const {
  return content_type_ == ContentType::kHTMLImageElement;
}
HTMLImageElement* GetAsHTMLImageElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLImageElement);
return member_html_image_element_.Get();
}
void Set(HTMLImageElement* value) {
  DCHECK(value);
Clear();
member_html_image_element_ = value;
content_type_ = ContentType::kHTMLImageElement;
}

bool IsHTMLVideoElement() const {
  return content_type_ == ContentType::kHTMLVideoElement;
}
HTMLVideoElement* GetAsHTMLVideoElement() const {
  DCHECK_EQ(content_type_, ContentType::kHTMLVideoElement);
return member_html_video_element_.Get();
}
void Set(HTMLVideoElement* value) {
  DCHECK(value);
Clear();
member_html_video_element_ = value;
content_type_ = ContentType::kHTMLVideoElement;
}

bool IsImageBitmap() const {
  return content_type_ == ContentType::kImageBitmap;
}
ImageBitmap* GetAsImageBitmap() const {
  DCHECK_EQ(content_type_, ContentType::kImageBitmap);
return member_image_bitmap_.Get();
}
void Set(ImageBitmap* value) {
  DCHECK(value);
Clear();
member_image_bitmap_ = value;
content_type_ = ContentType::kImageBitmap;
}

bool IsImageData() const {
  return content_type_ == ContentType::kImageData;
}
ImageData* GetAsImageData() const {
  DCHECK_EQ(content_type_, ContentType::kImageData);
return member_image_data_.Get();
}
void Set(ImageData* value) {
  DCHECK(value);
Clear();
member_image_data_ = value;
content_type_ = ContentType::kImageData;
}

bool IsOffscreenCanvas() const {
  return content_type_ == ContentType::kOffscreenCanvas;
}
OffscreenCanvas* GetAsOffscreenCanvas() const {
  DCHECK_EQ(content_type_, ContentType::kOffscreenCanvas);
return member_offscreen_canvas_.Get();
}
void Set(OffscreenCanvas* value) {
  DCHECK(value);
Clear();
member_offscreen_canvas_ = value;
content_type_ = ContentType::kOffscreenCanvas;
}

bool IsSVGImageElement() const {
  return content_type_ == ContentType::kSVGImageElement;
}
SVGImageElement* GetAsSVGImageElement() const {
  DCHECK_EQ(content_type_, ContentType::kSVGImageElement);
return member_svg_image_element_.Get();
}
void Set(SVGImageElement* value) {
  DCHECK(value);
Clear();
member_svg_image_element_ = value;
content_type_ = ContentType::kSVGImageElement;
}

bool IsVideoFrame() const {
  return content_type_ == ContentType::kVideoFrame;
}
VideoFrame* GetAsVideoFrame() const {
  DCHECK_EQ(content_type_, ContentType::kVideoFrame);
return member_video_frame_.Get();
}
void Set(VideoFrame* value) {
  DCHECK(value);
Clear();
member_video_frame_ = value;
content_type_ = ContentType::kVideoFrame;
}

bool IsV8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame() const {
  return content_type_ == ContentType::kHTMLCanvasElement || content_type_ == ContentType::kHTMLImageElement || content_type_ == ContentType::kHTMLVideoElement || content_type_ == ContentType::kImageBitmap || content_type_ == ContentType::kImageData || content_type_ == ContentType::kOffscreenCanvas || content_type_ == ContentType::kVideoFrame;
}
V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* GetAsV8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame() const;
void Set(const V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* value);
bool IsV8GPUImageCopyExternalImageSource() const {
  return IsV8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame();
}
V8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame* GetAsV8GPUImageCopyExternalImageSource() const {
  return GetAsV8UnionHTMLCanvasElementOrHTMLImageElementOrHTMLVideoElementOrImageBitmapOrImageDataOrOffscreenCanvasOrVideoFrame();
}

bool IsV8UnionHTMLCanvasElementOrOffscreenCanvas() const {
  return content_type_ == ContentType::kHTMLCanvasElement || content_type_ == ContentType::kOffscreenCanvas;
}
V8UnionHTMLCanvasElementOrOffscreenCanvas* GetAsV8UnionHTMLCanvasElementOrOffscreenCanvas() const;
void Set(const V8UnionHTMLCanvasElementOrOffscreenCanvas* value);

bool IsV8UnionHTMLVideoElementOrVideoFrame() const {
  return content_type_ == ContentType::kHTMLVideoElement || content_type_ == ContentType::kVideoFrame;
}
V8UnionHTMLVideoElementOrVideoFrame* GetAsV8UnionHTMLVideoElementOrVideoFrame() const;
void Set(const V8UnionHTMLVideoElementOrVideoFrame* value);


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(Blob or HTMLCanvasElement or HTMLImageElement or HTMLVideoElement or ImageBitmap or ImageData or OffscreenCanvas or SVGImageElement or VideoFrame)";
}

ContentType content_type_;

Member<Blob> member_blob_;
Member<HTMLCanvasElement> member_html_canvas_element_;
Member<HTMLImageElement> member_html_image_element_;
Member<HTMLVideoElement> member_html_video_element_;
Member<ImageBitmap> member_image_bitmap_;
Member<ImageData> member_image_data_;
Member<OffscreenCanvas> member_offscreen_canvas_;
Member<SVGImageElement> member_svg_image_element_;
Member<VideoFrame> member_video_frame_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_BLOB_HTMLCANVASELEMENT_HTMLIMAGEELEMENT_HTMLVIDEOELEMENT_IMAGEBITMAP_IMAGEDATA_OFFSCREENCANVAS_SVGIMAGEELEMENT_VIDEOFRAME_H_
