// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUDIOSINKOPTIONS_STRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUDIOSINKOPTIONS_STRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AudioSinkOptions;
class ExceptionState;
class ScriptState;

class MODULES_EXPORT V8UnionAudioSinkOptionsOrString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kAudioSinkOptions, kString
};

static V8UnionAudioSinkOptionsOrString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionAudioSinkOptionsOrString(AudioSinkOptions* value) : content_type_(ContentType::kAudioSinkOptions), member_audio_sink_options_(value) {
  DCHECK(value);
}
explicit  V8UnionAudioSinkOptionsOrString(const String& value);
explicit  V8UnionAudioSinkOptionsOrString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsAudioSinkOptions() const {
  return content_type_ == ContentType::kAudioSinkOptions;
}
AudioSinkOptions* GetAsAudioSinkOptions() const {
  DCHECK_EQ(content_type_, ContentType::kAudioSinkOptions);
return member_audio_sink_options_.Get();
}
void Set(AudioSinkOptions* value) {
  DCHECK(value);
Clear();
member_audio_sink_options_ = value;
content_type_ = ContentType::kAudioSinkOptions;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(AudioSinkOptions or DOMString)";
}

ContentType content_type_;

Member<AudioSinkOptions> member_audio_sink_options_;
String member_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUDIOSINKOPTIONS_STRING_H_
