// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUDIOSINKINFO_STRING_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUDIOSINKINFO_STRING_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AudioSinkInfo;
class ExceptionState;
class ScriptState;

class MODULES_EXPORT V8UnionAudioSinkInfoOrString final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kAudioSinkInfo, kString
};

static V8UnionAudioSinkInfoOrString* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionAudioSinkInfoOrString(AudioSinkInfo* value) : content_type_(ContentType::kAudioSinkInfo), member_audio_sink_info_(value) {
  DCHECK(value);
}
explicit  V8UnionAudioSinkInfoOrString(const String& value);
explicit  V8UnionAudioSinkInfoOrString(String&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsAudioSinkInfo() const {
  return content_type_ == ContentType::kAudioSinkInfo;
}
AudioSinkInfo* GetAsAudioSinkInfo() const {
  DCHECK_EQ(content_type_, ContentType::kAudioSinkInfo);
return member_audio_sink_info_.Get();
}
void Set(AudioSinkInfo* value) {
  DCHECK(value);
Clear();
member_audio_sink_info_ = value;
content_type_ = ContentType::kAudioSinkInfo;
}

bool IsString() const {
  return content_type_ == ContentType::kString;
}
const String& GetAsString() const {
  DCHECK_EQ(content_type_, ContentType::kString);
return member_string_;
}
void Set(const String& value);
void Set(String&& value);


v8::Local<v8::Value> ToV8(ScriptState* script_state) const;

void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(AudioSinkInfo or DOMString)";
}

ContentType content_type_;

Member<AudioSinkInfo> member_audio_sink_info_;
String member_string_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_AUDIOSINKINFO_STRING_H_
