// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_union_arraybuffer_gpubuffer.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_gpu_buffer.h"
#include "third_party/blink/renderer/modules/webgpu/gpu_buffer.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"

namespace blink {



V8UnionArrayBufferOrGPUBuffer* V8UnionArrayBufferOrGPUBuffer::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  if (V8GPUBuffer::HasInstance(isolate, v8_value)) {
  auto&& blink_value = V8GPUBuffer::ToWrappableUnsafe(isolate, v8_value.As<v8::Object>());
return MakeGarbageCollected<V8UnionArrayBufferOrGPUBuffer>(blink_value);
}
if (v8_value->IsArrayBuffer() || v8_value->IsSharedArrayBuffer()) {
  auto&& blink_value = NativeValueTraits<DOMArrayBuffer>::NativeValue(isolate, v8_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return MakeGarbageCollected<V8UnionArrayBufferOrGPUBuffer>(blink_value);
}
ThrowTypeErrorNotOfType(exception_state, UnionNameInIDL());
return nullptr;
}










void V8UnionArrayBufferOrGPUBuffer::Trace(Visitor* visitor) const {
  visitor->Trace(member_array_buffer_);
visitor->Trace(member_gpu_buffer_);
bindings::UnionBase::Trace(visitor);
}

void V8UnionArrayBufferOrGPUBuffer::Clear() {
  member_array_buffer_.Clear();
member_gpu_buffer_.Clear();
}



}  // namespace blink
