// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ADPROPERTIES_ADPROPERTIESSEQUENCE_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ADPROPERTIES_ADPROPERTIESSEQUENCE_H_

#include "base/check_op.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/union_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class AdProperties;
class ExceptionState;
class ScriptState;

class MODULES_EXPORT V8UnionAdPropertiesOrAdPropertiesSequence final : public bindings::UnionBase {
  
  public:
// The type of the content value of this IDL union.
enum class ContentType {
kAdProperties, kAdPropertiesSequence
};

static V8UnionAdPropertiesOrAdPropertiesSequence* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  V8UnionAdPropertiesOrAdPropertiesSequence(AdProperties* value) : content_type_(ContentType::kAdProperties), member_ad_properties_(value) {
  DCHECK(value);
}
explicit  V8UnionAdPropertiesOrAdPropertiesSequence(const HeapVector<Member<AdProperties>>& value);
explicit  V8UnionAdPropertiesOrAdPropertiesSequence(HeapVector<Member<AdProperties>>&& value);

// Returns the type of the content value.
ContentType GetContentType() const {
  return content_type_;
}

bool IsAdProperties() const {
  return content_type_ == ContentType::kAdProperties;
}
AdProperties* GetAsAdProperties() const {
  DCHECK_EQ(content_type_, ContentType::kAdProperties);
return member_ad_properties_.Get();
}
void Set(AdProperties* value) {
  DCHECK(value);
Clear();
member_ad_properties_ = value;
content_type_ = ContentType::kAdProperties;
}

bool IsAdPropertiesSequence() const {
  return content_type_ == ContentType::kAdPropertiesSequence;
}
const HeapVector<Member<AdProperties>>& GetAsAdPropertiesSequence() const {
  DCHECK_EQ(content_type_, ContentType::kAdPropertiesSequence);
return member_ad_properties_sequence_;
}
void Set(const HeapVector<Member<AdProperties>>& value);
void Set(HeapVector<Member<AdProperties>>&& value);


void Trace(Visitor* visitor) const override;


  
  private:
void Clear();

static constexpr const char* UnionNameInIDL() {
  return "(AdProperties or sequence<AdProperties>)";
}

ContentType content_type_;

Member<AdProperties> member_ad_properties_;
HeapVector<Member<AdProperties>> member_ad_properties_sequence_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_UNION_ADPROPERTIES_ADPROPERTIESSEQUENCE_H_
