// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_summarizer_create_core_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"expectedContextLanguages",
"expectedInputLanguages",
"format",
"length",
"outputLanguage",
"type",
};


}  // namespace 

SummarizerCreateCoreOptions* SummarizerCreateCoreOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  SummarizerCreateCoreOptions* dictionary = MakeGarbageCollected<SummarizerCreateCoreOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "SummarizerCreateCoreOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 SummarizerCreateCoreOptions::SummarizerCreateCoreOptions() {
  
}

 SummarizerCreateCoreOptions::SummarizerCreateCoreOptions(v8::Isolate* isolate) {
  
}



Vector<String> SummarizerCreateCoreOptions::getExpectedContextLanguagesOr(const Vector<String>& fallback_value) const {
  if (!hasExpectedContextLanguages()) {
  return fallback_value;
}
return member_expected_context_languages_;
}

Vector<String> SummarizerCreateCoreOptions::getExpectedContextLanguagesOr(Vector<String>&& fallback_value) const {
  if (!hasExpectedContextLanguages()) {
  return std::move(fallback_value);
}
return member_expected_context_languages_;
}

void SummarizerCreateCoreOptions::setExpectedContextLanguages(const Vector<String>& value) {
  member_expected_context_languages_ = value;
has_expected_context_languages_ = true;
}

void SummarizerCreateCoreOptions::setExpectedContextLanguages(Vector<String>&& value) {
  member_expected_context_languages_ = std::move(value);
has_expected_context_languages_ = true;
}




Vector<String> SummarizerCreateCoreOptions::getExpectedInputLanguagesOr(const Vector<String>& fallback_value) const {
  if (!hasExpectedInputLanguages()) {
  return fallback_value;
}
return member_expected_input_languages_;
}

Vector<String> SummarizerCreateCoreOptions::getExpectedInputLanguagesOr(Vector<String>&& fallback_value) const {
  if (!hasExpectedInputLanguages()) {
  return std::move(fallback_value);
}
return member_expected_input_languages_;
}

void SummarizerCreateCoreOptions::setExpectedInputLanguages(const Vector<String>& value) {
  member_expected_input_languages_ = value;
has_expected_input_languages_ = true;
}

void SummarizerCreateCoreOptions::setExpectedInputLanguages(Vector<String>&& value) {
  member_expected_input_languages_ = std::move(value);
has_expected_input_languages_ = true;
}














String SummarizerCreateCoreOptions::getOutputLanguageOr(const String& fallback_value) const {
  if (!hasOutputLanguage()) {
  return fallback_value;
}
return member_output_language_;
}

String SummarizerCreateCoreOptions::getOutputLanguageOr(String&& fallback_value) const {
  if (!hasOutputLanguage()) {
  return std::move(fallback_value);
}
return member_output_language_;
}

void SummarizerCreateCoreOptions::setOutputLanguage(const String& value) {
  member_output_language_ = value;
has_output_language_ = true;
}

void SummarizerCreateCoreOptions::setOutputLanguage(String&& value) {
  member_output_language_ = std::move(value);
has_output_language_ = true;
}








void SummarizerCreateCoreOptions::Trace(Visitor* visitor) const {
  bindings::InputDictionaryBase::Trace(visitor);
}

void SummarizerCreateCoreOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "SummarizerCreateCoreOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("expectedContextLanguages");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_expected_context_languages_, member_expected_context_languages_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("expectedInputLanguages");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_expected_input_languages_, member_expected_input_languages_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("format");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8SummarizerFormat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_format_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("length");
if (!bindings::GetDictionaryMemberFromV8Object<V8SummarizerLength, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_length_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("outputLanguage");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_output_language_, member_output_language_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("type");
if (!bindings::GetDictionaryMemberFromV8Object<V8SummarizerType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), fallback_presence_var, member_type_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> SummarizerCreateCoreOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
