// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_storage.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/modules/storage/storage_area.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/v8_dom_activity_logger.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_context_data.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8Storage::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8Storage::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8Storage::InstallInterfaceTemplate,
    nullptr,
    "Storage",
    nullptr,
    V8Storage::kThisTag,
    V8Storage::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& StorageArea::wrapper_type_info_ =
    V8Storage::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, StorageArea>::value,
    "StorageArea inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

v8::Intercepted V8Storage::NamedPropertyGetterCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_NamedPropertyGetter");

// LegacyPlatformObjectGetOwnProperty
// https://webidl.spec.whatwg.org/#LegacyPlatformObjectGetOwnProperty
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);

// Fast path for when the receiver doesn't have any named properties, possibly
// avoiding any parameter conversions.
if (!bindings::HasAnyNamedProperties(blink_receiver)) {    return v8::Intercepted::kNo;}
// "If the result of running the named property visibility
//  algorithm with property name P and object O is true, then:"
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->getItem(blink_property_name, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return v8::Intercepted::kYes;
}
if (return_value.IsNull()) {
  // "Return OrdinaryGetOwnProperty(O, P)."
return v8::Intercepted::kNo;
}

// "If operation was defined without an identifier, then set value to the result
//  of performing the steps listed in the interface description to determine the
//  value of a named property with P as the name."
// "Otherwise, operation was defined with an identifier. Set value to the result
//  of performing the steps listed in the description of operation with P as the
//  only argument value."
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
return v8::Intercepted::kYes;
}

v8::Intercepted V8Storage::NamedPropertySetterCallback(v8::Local<v8::Name> v8_property_name, v8::Local<v8::Value> v8_property_value, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_NamedPropertySetter");

// 3.9.2. [[Set]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-set
// step 1. If O and Receiver are the same object, then:
// (V8 calls this callback only when that's the case).
// TODO(https://crbug.com/455600234): remove this CHECK.
CHECK(info.HolderV2() == info.This());
// step 1.2.1. Invoke the named property setter with P and V.

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
ExceptionState exception_state(isolate);
auto&& blink_property_value = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return v8::Intercepted::kYes;
}
auto&& return_value = blink_receiver->setItem(blink_property_name, blink_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return v8::Intercepted::kYes;
}
bindings::V8SetReturnValue(info, return_value);
// Pretend like the set request was intercepted regardless of the actual
// return_value returned.
return v8::Intercepted::kYes;

}

v8::Intercepted V8Storage::NamedPropertyDeleterCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Boolean>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_NamedPropertyDeleter");

// 3.9.4. [[Delete]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-delete

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->removeItem(blink_property_name, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return v8::Intercepted::kYes;
}
bindings::V8SetReturnValue(info, return_value);
if (return_value == NamedPropertyDeleterResult::kDidNotDelete) {
  if (info.ShouldThrowOnError()) {
  V8ThrowException::ThrowTypeError(isolate, "Failed to delete a property.");
}
return v8::Intercepted::kYes;
}
return BlinkInterceptorResultToV8Intercepted(return_value);
}

v8::Intercepted V8Storage::NamedPropertyDefinerCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyDescriptor& v8_property_desc, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_NamedPropertyDefiner");

// 3.9.3. [[DefineOwnProperty]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-defineownproperty
// step 2.2.2. If O implements an interface with a named property setter,
//   then:
// step 2.2.2.1. If the result of calling IsDataDescriptor(Desc) is false,
//   then return false.

v8::Isolate* isolate = info.GetIsolate();
if (v8_property_desc.has_get() || v8_property_desc.has_set()) {
  if (info.ShouldThrowOnError()) {
  V8ThrowException::ThrowTypeError(isolate,  "Accessor properties are not allowed.");
}
return v8::Intercepted::kYes;
}

// step 2.2.2.2. Invoke the named property setter with P and Desc.[[Value]].
return V8Storage::NamedPropertySetterCallback(
    v8_property_name,
    v8_property_desc.has_value()
        ? v8_property_desc.value()
        : v8::Undefined(isolate).As<v8::Value>(),
    info);

}

v8::Intercepted V8Storage::NamedPropertyDescriptorCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_NamedPropertyDescriptor");

// LegacyPlatformObjectGetOwnProperty
// https://webidl.spec.whatwg.org/#LegacyPlatformObjectGetOwnProperty

// "If the result of running the named property visibility algorithm with
//  property name P and object O is true, then:"
v8::Local<v8::Object> v8_receiver = info.HolderV2();
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
if (v8_receiver->GetRealNamedPropertyAttributesInPrototypeChain(
        current_context, v8_property_name).IsJust()) {
  // Do not intercept.  Fallback to OrdinaryGetOwnProperty.
  return v8::Intercepted::kNo;
}

// "If operation was defined without an identifier, then set value to the result
//  of performing the steps listed in the interface description to determine the
//  value of a named property with P as the name."
// "Otherwise, operation was defined with an identifier. Set value to the result
//  of performing the steps listed in the description of operation with P as the
//  only argument value."
auto intercepted =
    V8Storage::NamedPropertyGetterCallback(v8_property_name, info);
// "Return OrdinaryGetOwnProperty(O, P)."
if (intercepted == v8::Intercepted::kNo) {
  // Do not intercept.  Fallback to OrdinaryGetOwnProperty.
  return v8::Intercepted::kNo;
}

// "Let desc be a newly created Property Descriptor with no fields."
// "Set desc.[[Value]] to the result of converting value to an ECMAScript
//  value."
// "If O implements an interface with a named property setter, then set
//  desc.[[Writable]] to true, otherwise set it to false."
// "If O implements an interface with the [LegacyUnenumerableNamedProperties]
//  extended attribute, then set desc.[[Enumerable]] to false, otherwise set
//  it to true."
// "Set desc.[[Configurable]] to true."
// "Return desc."
v8::Local<v8::Value> v8_value = info.GetReturnValue().Get();
v8::PropertyDescriptor desc(v8_value, /*writable=*/true);
desc.set_enumerable(true);
desc.set_configurable(true);
bindings::V8SetReturnValue(info, desc);
return v8::Intercepted::kYes;

}

v8::Intercepted V8Storage::NamedPropertyQueryCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Integer>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_NamedPropertyQuery");

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);
const AtomicString& blink_property_name = ToCoreAtomicString(isolate, v8_property_name);
ExceptionState exception_state(isolate);
bool does_exist = blink_receiver->NamedPropertyQuery(blink_property_name, exception_state);
if (!does_exist) {
  return v8::Intercepted::kNo;
}
bindings::V8SetReturnValue(info, uint32_t(v8::None));
return v8::Intercepted::kYes;
}

void V8Storage::NamedPropertyEnumeratorCallback(const v8::PropertyCallbackInfo<v8::Array>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_NamedPropertyEnumerator");

// 3.9.6. [[OwnPropertyKeys]]
// https://webidl.spec.whatwg.org/#legacy-platform-object-ownpropertykeys
// step 3. If O supports named properties, then for each P of O's supported
//   property names that is visible according to the named property
//   visibility algorithm, append P to keys.
Vector<String> blink_property_names;
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.HolderV2();
StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
blink_receiver->NamedPropertyEnumerator(blink_property_names, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
bindings::V8SetReturnValue(
    info,
    ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state,
                                             blink_property_names)
         .As<v8::Array>());

}

v8::Intercepted V8Storage::IndexedPropertyGetterCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_IndexedPropertyGetter");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8Storage::NamedPropertyGetterCallback(
    V8AtomicString(isolate, blink_property_index), info);

}

v8::Intercepted V8Storage::IndexedPropertySetterCallback(uint32_t index, v8::Local<v8::Value> v8_property_value, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_IndexedPropertySetter");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8Storage::NamedPropertySetterCallback(
    V8AtomicString(isolate, blink_property_index), v8_property_value,
    info);

}

v8::Intercepted V8Storage::IndexedPropertyDeleterCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Boolean>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_IndexedPropertyDeleter");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8Storage::NamedPropertyDeleterCallback(
    V8AtomicString(isolate, blink_property_index), info);

}

v8::Intercepted V8Storage::IndexedPropertyDefinerCallback(uint32_t index, const v8::PropertyDescriptor& v8_property_desc, const v8::PropertyCallbackInfo<void>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_IndexedPropertyDefiner");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8Storage::NamedPropertyDefinerCallback(
    V8AtomicString(isolate, blink_property_index), v8_property_desc,
    info);

}

v8::Intercepted V8Storage::IndexedPropertyDescriptorCallback(uint32_t index, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_IndexedPropertyDescriptor");

v8::Isolate* isolate = info.GetIsolate();
const AtomicString& blink_property_index = AtomicString::Number(index);
return V8Storage::NamedPropertyDescriptorCallback(
    V8AtomicString(isolate, blink_property_index), info);

}


namespace  {

namespace v8_storage {


void LengthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_length_Getter");
BLINK_BINDINGS_TRACE_EVENT("Storage.length.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->length(exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}


void ClearOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_clear");
BLINK_BINDINGS_TRACE_EVENT("Storage.clear");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kDOMStorageWrite);
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
V8PerContextData* per_context_data = script_state->PerContextData();
// [LogActivity], [LogAllWorlds]
if (per_context_data && per_context_data->ActivityLogger()) [[unlikely]] { per_context_data->ActivityLogger()->LogMethod(script_state, "Storage.clear", info); }



StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
blink_receiver->clear(exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void GetItemOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_getItem");
BLINK_BINDINGS_TRACE_EVENT("Storage.getItem");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kDOMStorageRead);
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
V8PerContextData* per_context_data = script_state->PerContextData();
// [LogActivity], [LogAllWorlds]
if (per_context_data && per_context_data->ActivityLogger()) [[unlikely]] { per_context_data->ActivityLogger()->LogMethod(script_state, "Storage.getItem", info); }

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_key = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getItem(arg1_key, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void KeyOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_key");
BLINK_BINDINGS_TRACE_EVENT("Storage.key");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kDOMStorageRead);

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->key(arg1_index, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void RemoveItemOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_removeItem");
BLINK_BINDINGS_TRACE_EVENT("Storage.removeItem");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kDOMStorageWrite);
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
V8PerContextData* per_context_data = script_state->PerContextData();
// [LogActivity], [LogAllWorlds]
if (per_context_data && per_context_data->ActivityLogger()) [[unlikely]] { per_context_data->ActivityLogger()->LogMethod(script_state, "Storage.removeItem", info); }

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_key = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->removeItem(arg1_key, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void SetItemOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_StorageArea_setItem");
BLINK_BINDINGS_TRACE_EVENT("Storage.setItem");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kDOMStorageWrite);
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
V8PerContextData* per_context_data = script_state->PerContextData();
// [LogActivity], [LogAllWorlds]
if (per_context_data && per_context_data->ActivityLogger()) [[unlikely]] { per_context_data->ActivityLogger()->LogMethod(script_state, "Storage.setItem", info); }

if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


StorageArea* blink_receiver = V8Storage::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_key = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_value = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setItem(arg1_key, arg2_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_storage

using namespace v8_storage;

}  // namespace 

void V8Storage::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8Storage::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);



// Named interceptors
instance_template->SetHandler(
    v8::NamedPropertyHandlerConfiguration(
        V8Storage::NamedPropertyGetterCallback,
        V8Storage::NamedPropertySetterCallback,
        V8Storage::NamedPropertyQueryCallback,
        V8Storage::NamedPropertyDeleterCallback,
        V8Storage::NamedPropertyEnumeratorCallback,
        V8Storage::NamedPropertyDefinerCallback,
        V8Storage::NamedPropertyDescriptorCallback,
        v8::Local<v8::Value>(),
        static_cast<v8::PropertyHandlerFlags>(int32_t(v8::PropertyHandlerFlags::kOnlyInterceptStrings) | int32_t(v8::PropertyHandlerFlags::kNonMasking) | int32_t(v8::PropertyHandlerFlags::kHasNoSideEffect))));
// Indexed interceptors
instance_template->SetHandler(
    v8::IndexedPropertyHandlerConfiguration(
        V8Storage::IndexedPropertyGetterCallback,
        V8Storage::IndexedPropertySetterCallback,
        nullptr,  // query
        V8Storage::IndexedPropertyDeleterCallback,
        nullptr,  // enumerator
        V8Storage::IndexedPropertyDefinerCallback,
        V8Storage::IndexedPropertyDescriptorCallback,
        v8::Local<v8::Value>(),
        v8::PropertyHandlerFlags::kNone));


InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8Storage::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"length", LengthAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "Storage", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"clear", ClearOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getItem", GetItemOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"key", KeyOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"removeItem", RemoveItemOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"setItem", SetItemOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "Storage", kOperationTable);
}



}




}  // namespace blink
