// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_smart_card_transaction_callback.h"

#include <tuple>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"

namespace blink {





const char* V8SmartCardTransactionCallback::GetHumanReadableName() const {
  return "V8SmartCardTransactionCallback";
}

v8::Maybe<ScriptPromise<IDLNullable<V8SmartCardDisposition>>> V8SmartCardTransactionCallback::Invoke(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver) {
  const char* const class_like_name = "SmartCardTransactionCallback";
const char* const property_name = "invoke";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kDefault, bindings::CallbackReturnTypeIsPromise::kYes> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}
return helper.Result<IDLPromise<IDLNullable<V8SmartCardDisposition>>, ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}
base::span<v8::Local<v8::Value>> argv;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}
return helper.Result<IDLPromise<IDLNullable<V8SmartCardDisposition>>, ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}

v8::Maybe<ScriptPromise<IDLNullable<V8SmartCardDisposition>>> V8SmartCardTransactionCallback::Construct() {
  const char* const class_like_name = "SmartCardTransactionCallback";
const char* const property_name = "construct";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}

bindings::CallbackInvokeHelper<CallbackFunctionBase, bindings::CallbackInvokeHelperMode::kConstructorCall, bindings::CallbackReturnTypeIsPromise::kYes> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(nullptr)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}
return helper.Result<IDLPromise<IDLNullable<V8SmartCardDisposition>>, ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}
base::span<v8::Local<v8::Value>> argv;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}
return helper.Result<IDLPromise<IDLNullable<V8SmartCardDisposition>>, ScriptPromise<IDLNullable<V8SmartCardDisposition>>>();
}




}  // namespace blink
