// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_smart_card_reader_state_out.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_smart_card_reader_state_flags_out.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"answerToReset",
"eventCount",
"eventState",
"readerName",
};


}  // namespace 

SmartCardReaderStateOut* SmartCardReaderStateOut::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  SmartCardReaderStateOut* dictionary = MakeGarbageCollected<SmartCardReaderStateOut>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "SmartCardReaderStateOut";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 SmartCardReaderStateOut::SmartCardReaderStateOut() {
  
}

 SmartCardReaderStateOut::SmartCardReaderStateOut(v8::Isolate* isolate) {
  
}


















void SmartCardReaderStateOut::setReaderName(const String& value) {
  member_reader_name_ = value;
}

void SmartCardReaderStateOut::setReaderName(String&& value) {
  member_reader_name_ = std::move(value);
}



void SmartCardReaderStateOut::Trace(Visitor* visitor) const {
  visitor->Trace(member_answer_to_reset_);
visitor->Trace(member_event_state_);
bindings::DictionaryBase::Trace(visitor);
}

void SmartCardReaderStateOut::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void SmartCardReaderStateOut::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAnswerToReset()) {
  values[0] = ToV8Traits<DOMArrayBuffer>::ToV8(script_state, member_answer_to_reset_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasEventCount()) {
  values[1] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_event_count_);
DCHECK(!values[1].IsEmpty());
}
if (hasEventState()) {
  values[2] = ToV8Traits<SmartCardReaderStateFlagsOut>::ToV8(script_state, member_event_state_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasReaderName()) {
  values[3] = ToV8Traits<IDLString>::ToV8(script_state, member_reader_name_);
DCHECK(!values[3].IsEmpty());
}
}

const void* SmartCardReaderStateOut::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> SmartCardReaderStateOut::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void SmartCardReaderStateOut::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "SmartCardReaderStateOut";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("answerToReset");
constexpr bool is_required = true;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<DOMArrayBuffer, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_answer_to_reset_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("eventCount");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_event_count_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("eventState");
if (!bindings::GetDictionaryMemberFromV8Object<SmartCardReaderStateFlagsOut, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_event_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("readerName");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_reader_name_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> SmartCardReaderStateOut::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
