// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_smart_card_connection_status.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"answerToReset",
"readerName",
"state",
};


}  // namespace 

SmartCardConnectionStatus* SmartCardConnectionStatus::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  SmartCardConnectionStatus* dictionary = MakeGarbageCollected<SmartCardConnectionStatus>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "SmartCardConnectionStatus";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 SmartCardConnectionStatus::SmartCardConnectionStatus() {
  
}

 SmartCardConnectionStatus::SmartCardConnectionStatus(v8::Isolate* isolate) {
  
}










void SmartCardConnectionStatus::setReaderName(const String& value) {
  member_reader_name_ = value;
}

void SmartCardConnectionStatus::setReaderName(String&& value) {
  member_reader_name_ = std::move(value);
}








void SmartCardConnectionStatus::Trace(Visitor* visitor) const {
  visitor->Trace(member_answer_to_reset_);
bindings::DictionaryBase::Trace(visitor);
}

void SmartCardConnectionStatus::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void SmartCardConnectionStatus::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAnswerToReset()) {
  values[0] = ToV8Traits<DOMArrayBuffer>::ToV8(script_state, member_answer_to_reset_.Get());
DCHECK(!values[0].IsEmpty());
}
if (hasReaderName()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_reader_name_);
DCHECK(!values[1].IsEmpty());
}
if (hasState()) {
  values[2] = ToV8Traits<V8SmartCardConnectionState>::ToV8(script_state, member_state_);
DCHECK(!values[2].IsEmpty());
}
}

const void* SmartCardConnectionStatus::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> SmartCardConnectionStatus::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void SmartCardConnectionStatus::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "SmartCardConnectionStatus";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("answerToReset");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<DOMArrayBuffer, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_answer_to_reset_, member_answer_to_reset_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("readerName");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_reader_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("state");
if (!bindings::GetDictionaryMemberFromV8Object<V8SmartCardConnectionState, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_state_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> SmartCardConnectionStatus::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
