// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_shared_storage_worklet_global_scope.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_byte_length_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_count_queuing_strategy.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_no_argument_constructor.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_quota_exceeded_error.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_byte_stream_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_byob_request.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_readable_stream_default_reader.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_transform_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_worklet_global_scope.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_controller.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_writable_stream_default_writer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_crypto.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_crypto_key.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_lock.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_lock_manager.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_private_aggregation.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_shared_storage.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_shared_storage_append_method.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_shared_storage_clear_method.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_shared_storage_delete_method.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_shared_storage_modifier_method.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_shared_storage_set_method.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_shared_storage_worklet_navigator.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_storage_interest_group.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_subtle_crypto.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_decoder.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_text_encoder.h"
#include "third_party/blink/renderer/core/context_features/context_feature_settings.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/crypto/crypto.h"
#include "third_party/blink/renderer/modules/shared_storage/private_aggregation.h"
#include "third_party/blink/renderer/modules/shared_storage/shared_storage.h"
#include "third_party/blink/renderer/modules/shared_storage/shared_storage_worklet_global_scope.h"
#include "third_party/blink/renderer/modules/shared_storage/shared_storage_worklet_navigator.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



bool V8SharedStorageWorkletGlobalScope::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsSharedStorageWorkletGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8SharedStorageWorkletGlobalScope::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8SharedStorageWorkletGlobalScope::InstallInterfaceTemplate,
    V8SharedStorageWorkletGlobalScope::InstallContextDependentProperties,
    "SharedStorageWorkletGlobalScope",
    V8WorkletGlobalScope::GetWrapperTypeInfo(),
    V8SharedStorageWorkletGlobalScope::kThisTag,
    V8SharedStorageWorkletGlobalScope::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& SharedStorageWorkletGlobalScope::wrapper_type_info_ =
    V8SharedStorageWorkletGlobalScope::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, SharedStorageWorkletGlobalScope>::value,
    "SharedStorageWorkletGlobalScope does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_shared_storage_worklet_global_scope {


void SharedStorageAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_sharedStorage_Getter");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.sharedStorage.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
SharedStorageWorkletGlobalScope* blink_receiver = V8SharedStorageWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->sharedStorage(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<SharedStorage, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void PrivateAggregationAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_privateAggregation_Getter");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.privateAggregation.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
SharedStorageWorkletGlobalScope* blink_receiver = V8SharedStorageWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->privateAggregation(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<PrivateAggregation, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void CryptoAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_crypto_Getter");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.crypto.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
SharedStorageWorkletGlobalScope* blink_receiver = V8SharedStorageWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->crypto(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<Crypto, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}



void NavigatorAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_navigator_Getter");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.navigator.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
SharedStorageWorkletGlobalScope* blink_receiver = V8SharedStorageWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& return_value = blink_receiver->Navigator(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<SharedStorageWorkletNavigator, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}


void ByteLengthQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_ByteLengthQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.ByteLengthQueuingStrategy");

bindings::V8SetReturnValue(info, V8ByteLengthQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CountQueuingStrategyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_CountQueuingStrategy_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.CountQueuingStrategy");

bindings::V8SetReturnValue(info, V8CountQueuingStrategy::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CryptoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_Crypto_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.Crypto");

bindings::V8SetReturnValue(info, V8Crypto::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void CryptoKeyExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_CryptoKey_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.CryptoKey");

bindings::V8SetReturnValue(info, V8CryptoKey::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LockExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_Lock_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.Lock");

bindings::V8SetReturnValue(info, V8Lock::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void LockManagerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_LockManager_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.LockManager");

bindings::V8SetReturnValue(info, V8LockManager::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void PrivateAggregationExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_PrivateAggregation_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.PrivateAggregation");

bindings::V8SetReturnValue(info, V8PrivateAggregation::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void QuotaExceededErrorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_QuotaExceededError_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.QuotaExceededError");

bindings::V8SetReturnValue(info, V8QuotaExceededError::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableByteStreamControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_ReadableByteStreamController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.ReadableByteStreamController");

bindings::V8SetReturnValue(info, V8ReadableByteStreamController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_ReadableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.ReadableStream");

bindings::V8SetReturnValue(info, V8ReadableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_ReadableStreamBYOBReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.ReadableStreamBYOBReader");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamBYOBRequestExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_ReadableStreamBYOBRequest_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.ReadableStreamBYOBRequest");

bindings::V8SetReturnValue(info, V8ReadableStreamBYOBRequest::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_ReadableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.ReadableStreamDefaultController");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void ReadableStreamDefaultReaderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_ReadableStreamDefaultReader_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.ReadableStreamDefaultReader");

bindings::V8SetReturnValue(info, V8ReadableStreamDefaultReader::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SharedStorageExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_SharedStorage_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.SharedStorage");

bindings::V8SetReturnValue(info, V8SharedStorage::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SharedStorageAppendMethodExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_SharedStorageAppendMethod_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.SharedStorageAppendMethod");

bindings::V8SetReturnValue(info, V8SharedStorageAppendMethod::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SharedStorageClearMethodExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_SharedStorageClearMethod_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.SharedStorageClearMethod");

bindings::V8SetReturnValue(info, V8SharedStorageClearMethod::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SharedStorageDeleteMethodExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_SharedStorageDeleteMethod_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.SharedStorageDeleteMethod");

bindings::V8SetReturnValue(info, V8SharedStorageDeleteMethod::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SharedStorageModifierMethodExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_SharedStorageModifierMethod_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.SharedStorageModifierMethod");

bindings::V8SetReturnValue(info, V8SharedStorageModifierMethod::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SharedStorageSetMethodExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_SharedStorageSetMethod_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.SharedStorageSetMethod");

bindings::V8SetReturnValue(info, V8SharedStorageSetMethod::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SharedStorageWorkletGlobalScopeExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_SharedStorageWorkletGlobalScope_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.SharedStorageWorkletGlobalScope");

bindings::V8SetReturnValue(info, V8SharedStorageWorkletGlobalScope::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SharedStorageWorkletNavigatorExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_SharedStorageWorkletNavigator_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.SharedStorageWorkletNavigator");

bindings::V8SetReturnValue(info, V8SharedStorageWorkletNavigator::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void SubtleCryptoExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_SubtleCrypto_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.SubtleCrypto");

bindings::V8SetReturnValue(info, V8SubtleCrypto::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextDecoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_TextDecoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.TextDecoder");

bindings::V8SetReturnValue(info, V8TextDecoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TextEncoderExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_TextEncoder_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.TextEncoder");

bindings::V8SetReturnValue(info, V8TextEncoder::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_TransformStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.TransformStream");

bindings::V8SetReturnValue(info, V8TransformStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void TransformStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_TransformStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.TransformStreamDefaultController");

bindings::V8SetReturnValue(info, V8TransformStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_WritableStream_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.WritableStream");

bindings::V8SetReturnValue(info, V8WritableStream::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultControllerExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_WritableStreamDefaultController_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.WritableStreamDefaultController");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultController::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void WritableStreamDefaultWriterExposedConstructCallback(v8::Local<v8::Name> v8_property_name, const v8::PropertyCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_WritableStreamDefaultWriter_ConstructorGetterCallback");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.WritableStreamDefaultWriter");

bindings::V8SetReturnValue(info, V8WritableStreamDefaultWriter::GetWrapperTypeInfo(), bindings::V8ReturnValue::kInterfaceObject);
}

void InterestGroupsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_interestGroups");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.interestGroups");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8SharedStorageWorkletGlobalScope::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}




SharedStorageWorkletGlobalScope* blink_receiver = V8SharedStorageWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "SharedStorageWorkletGlobalScope";
const char* const property_name = "interestGroups";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = blink_receiver->interestGroups(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLSequence<StorageInterestGroup>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void RegisterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_SharedStorageWorkletGlobalScope_register");
BLINK_BINDINGS_TRACE_EVENT("SharedStorageWorkletGlobalScope.register");



v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
SharedStorageWorkletGlobalScope* blink_receiver = V8SharedStorageWorkletGlobalScope::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_operation_ctor = NativeValueTraits<V8NoArgumentConstructor>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->Register(arg1_name, arg2_operation_ctor, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


}  // namespace v8_shared_storage_worklet_global_scope

using namespace v8_shared_storage_worklet_global_scope;

}  // namespace 

void V8SharedStorageWorkletGlobalScope::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8SharedStorageWorkletGlobalScope::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template = wrapper_type_info->parent_class->GetV8ClassTemplate(isolate, world).As<v8::FunctionTemplate>();
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






// [Global]
// 3.7.1. [[SetPrototypeOf]]
// https://webidl.spec.whatwg.org/#platform-object-setprototypeof
instance_template->SetImmutableProto();
prototype_template->SetImmutableProto();

InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8SharedStorageWorkletGlobalScope::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"sharedStorage", SharedStorageAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"crypto", CryptoAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "SharedStorageWorkletGlobalScope", kAttributeTable);
}




{
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"ByteLengthQueuingStrategy", ByteLengthQueuingStrategyExposedConstructCallback}, 
{"CountQueuingStrategy", CountQueuingStrategyExposedConstructCallback}, 
{"Crypto", CryptoExposedConstructCallback}, 
{"ReadableByteStreamController", ReadableByteStreamControllerExposedConstructCallback}, 
{"ReadableStream", ReadableStreamExposedConstructCallback}, 
{"ReadableStreamBYOBReader", ReadableStreamBYOBReaderExposedConstructCallback}, 
{"ReadableStreamBYOBRequest", ReadableStreamBYOBRequestExposedConstructCallback}, 
{"ReadableStreamDefaultController", ReadableStreamDefaultControllerExposedConstructCallback}, 
{"ReadableStreamDefaultReader", ReadableStreamDefaultReaderExposedConstructCallback}, 
{"SharedStorageWorkletGlobalScope", SharedStorageWorkletGlobalScopeExposedConstructCallback}, 
{"TextDecoder", TextDecoderExposedConstructCallback}, 
{"TextEncoder", TextEncoderExposedConstructCallback}, 
{"TransformStream", TransformStreamExposedConstructCallback}, 
{"TransformStreamDefaultController", TransformStreamDefaultControllerExposedConstructCallback}, 
{"WritableStream", WritableStreamExposedConstructCallback}, 
{"WritableStreamDefaultController", WritableStreamDefaultControllerExposedConstructCallback}, 
{"WritableStreamDefaultWriter", WritableStreamDefaultWriterExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}


{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"register", RegisterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "SharedStorageWorkletGlobalScope", kOperationTable);
}



}

void V8SharedStorageWorkletGlobalScope::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::SharedStorageWebLocksEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"navigator", NavigatorAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "SharedStorageWorkletGlobalScope", kAttributeTable);
}



if (RuntimeEnabledFeatures::QuotaExceededErrorUpdateEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"QuotaExceededError", QuotaExceededErrorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::SharedStorageAPIEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"SharedStorage", SharedStorageExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}
if (RuntimeEnabledFeatures::SharedStorageWebLocksEnabled()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"SharedStorageAppendMethod", SharedStorageAppendMethodExposedConstructCallback}, 
{"SharedStorageClearMethod", SharedStorageClearMethodExposedConstructCallback}, 
{"SharedStorageDeleteMethod", SharedStorageDeleteMethodExposedConstructCallback}, 
{"SharedStorageModifierMethod", SharedStorageModifierMethodExposedConstructCallback}, 
{"SharedStorageSetMethod", SharedStorageSetMethodExposedConstructCallback}, 
{"SharedStorageWorkletNavigator", SharedStorageWorkletNavigatorExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_template, prototype_template, interface_template, signature, kExposedConstructTable);
}

if (RuntimeEnabledFeatures::InterestGroupsInSharedStorageWorkletEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"interestGroups", InterestGroupsOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "SharedStorageWorkletGlobalScope", kOperationTable);
}


}

void V8SharedStorageWorkletGlobalScope::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;

if (instance_object.IsEmpty()) {
  instance_object = context->Global();
}

v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
const ContextFeatureSettings* context_feature_settings = ContextFeatureSettings::From(execution_context, ContextFeatureSettings::CreationMode::kDontCreateIfNotExists);
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (feature_selector.IsAll() && (context_feature_settings && context_feature_settings->isPrivateAggregationInSharedStorageEnabled())) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"privateAggregation", PrivateAggregationAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kInstance), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_object, prototype_object, interface_object, signature, "SharedStorageWorkletGlobalScope", kAttributeTable);
}



const bool is_in_secure_context = execution_context->IsSecureContext();
if (is_in_secure_context && feature_selector.IsAll()) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"CryptoKey", CryptoKeyExposedConstructCallback}, 
{"SubtleCrypto", SubtleCryptoExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::SharedStorageWebLocksEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"Lock", LockExposedConstructCallback}, 
{"LockManager", LockManagerExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}
if (feature_selector.IsAll() && (context_feature_settings && context_feature_settings->isPrivateAggregationInSharedStorageEnabled())) {
  static const IDLMemberInstaller::ExposedConstructConfig kExposedConstructTable[] = {
{"PrivateAggregation", PrivateAggregationExposedConstructCallback}, 
};
IDLMemberInstaller::InstallExposedConstructs(isolate, world, instance_object, prototype_object, interface_object, signature, kExposedConstructTable);
}



}


}  // namespace blink
