// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARE_DATA_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARE_DATA_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class File;

class MODULES_EXPORT ShareData : public bindings::InputDictionaryBase {
  
  public:
static ShareData* Create() {
  return MakeGarbageCollected<ShareData>();
}
static ShareData* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ShareData>(isolate);
}
static ShareData* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ShareData();
explicit  ShareData(v8::Isolate* isolate);

bool hasFiles() const {
  return has_files_;
}
const HeapVector<Member<File>>& files() const {
  DCHECK(hasFiles());
return member_files_;
}
HeapVector<Member<File>> getFilesOr(const HeapVector<Member<File>>& fallback_value) const;
HeapVector<Member<File>> getFilesOr(HeapVector<Member<File>>&& fallback_value) const;
void setFiles(const HeapVector<Member<File>>& value);
void setFiles(HeapVector<Member<File>>&& value);

bool hasText() const {
  return has_text_;
}
const String& text() const {
  DCHECK(hasText());
return member_text_;
}
String getTextOr(const String& fallback_value) const;
String getTextOr(String&& fallback_value) const;
void setText(const String& value);
void setText(String&& value);

bool hasTitle() const {
  return has_title_;
}
const String& title() const {
  DCHECK(hasTitle());
return member_title_;
}
String getTitleOr(const String& fallback_value) const;
String getTitleOr(String&& fallback_value) const;
void setTitle(const String& value);
void setTitle(String&& value);

bool hasUrl() const {
  return has_url_;
}
const String& url() const {
  DCHECK(hasUrl());
return member_url_;
}
String getUrlOr(const String& fallback_value) const;
String getUrlOr(String&& fallback_value) const;
void setUrl(const String& value);
void setUrl(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_files_ = false;
bool has_text_ = false;
bool has_title_ = false;
bool has_url_ = false;

HeapVector<Member<File>> member_files_;
String member_text_;
String member_title_;
String member_url_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SHARE_DATA_H_
