// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_flow_control_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_parity_type.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT SerialOptions : public bindings::InputDictionaryBase {
  
  public:
static SerialOptions* Create() {
  return MakeGarbageCollected<SerialOptions>();
}
static SerialOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<SerialOptions>(isolate);
}
static SerialOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  SerialOptions();
explicit  SerialOptions(v8::Isolate* isolate);

bool hasBaudRate() const {
  return true;
}
uint32_t baudRate() const {
  return member_baud_rate_;
}
void setBaudRate(uint32_t value) {
  member_baud_rate_ = value;
}

bool hasBufferSize() const {
  return true;
}
uint32_t bufferSize() const {
  return member_buffer_size_;
}
void setBufferSize(uint32_t value) {
  member_buffer_size_ = value;
}

bool hasDataBits() const {
  return true;
}
uint8_t dataBits() const {
  return member_data_bits_;
}
void setDataBits(uint8_t value) {
  member_data_bits_ = value;
}

bool hasFlowControl() const {
  return true;
}
V8FlowControlType flowControl() const {
  return member_flow_control_;
}
void setFlowControl(V8FlowControlType value) {
  member_flow_control_ = value;
}
void setFlowControl(V8FlowControlType::Enum value) {
  member_flow_control_ = V8FlowControlType(value);
}

bool hasParity() const {
  return true;
}
V8ParityType parity() const {
  return member_parity_;
}
void setParity(V8ParityType value) {
  member_parity_ = value;
}
void setParity(V8ParityType::Enum value) {
  member_parity_ = V8ParityType(value);
}

bool hasStopBits() const {
  return true;
}
uint8_t stopBits() const {
  return member_stop_bits_;
}
void setStopBits(uint8_t value) {
  member_stop_bits_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 6;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



uint32_t member_baud_rate_;
uint32_t member_buffer_size_{255};
uint8_t member_data_bits_{8};
V8FlowControlType member_flow_control_{V8FlowControlType::Enum::kNone};
V8ParityType member_parity_{V8ParityType::Enum::kNone};
uint8_t member_stop_bits_{1};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_SERIAL_OPTIONS_H_
