// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRANSPORT_CONFIG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRANSPORT_CONFIG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_transport_wire_protocol.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class RTCIceServer;

class MODULES_EXPORT RtcTransportConfig : public bindings::InputDictionaryBase {
  
  public:
static RtcTransportConfig* Create() {
  return MakeGarbageCollected<RtcTransportConfig>();
}
static RtcTransportConfig* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RtcTransportConfig>(isolate);
}
static RtcTransportConfig* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RtcTransportConfig();
explicit  RtcTransportConfig(v8::Isolate* isolate);

bool hasIceControlling() const {
  return true;
}
bool iceControlling() const {
  return member_ice_controlling_;
}
void setIceControlling(bool value) {
  member_ice_controlling_ = value;
}

bool hasIceServers() const {
  return has_ice_servers_;
}
const HeapVector<Member<RTCIceServer>>& iceServers() const {
  DCHECK(hasIceServers());
return member_ice_servers_;
}
HeapVector<Member<RTCIceServer>> getIceServersOr(const HeapVector<Member<RTCIceServer>>& fallback_value) const;
HeapVector<Member<RTCIceServer>> getIceServersOr(HeapVector<Member<RTCIceServer>>&& fallback_value) const;
void setIceServers(const HeapVector<Member<RTCIceServer>>& value);
void setIceServers(HeapVector<Member<RTCIceServer>>&& value);

bool hasName() const {
  return has_name_;
}
const String& name() const {
  DCHECK(hasName());
return member_name_;
}
String getNameOr(const String& fallback_value) const;
String getNameOr(String&& fallback_value) const;
void setName(const String& value);
void setName(String&& value);

bool hasWireProtocol() const {
  return true;
}
V8RtcTransportWireProtocol wireProtocol() const {
  return member_wire_protocol_;
}
void setWireProtocol(V8RtcTransportWireProtocol value) {
  member_wire_protocol_ = value;
}
void setWireProtocol(V8RtcTransportWireProtocol::Enum value) {
  member_wire_protocol_ = V8RtcTransportWireProtocol(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_ice_servers_ = false;
bool has_name_ = false;

bool member_ice_controlling_;
HeapVector<Member<RTCIceServer>> member_ice_servers_;
String member_name_;
V8RtcTransportWireProtocol member_wire_protocol_{V8RtcTransportWireProtocol::Enum::kDtlsSrtp};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_TRANSPORT_CONFIG_H_
