// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_TRANSCEIVER_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_TRANSCEIVER_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_transceiver_direction.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"

namespace blink {

class ExceptionState;
class MediaStream;
class RTCRtpEncodingParameters;

class MODULES_EXPORT RTCRtpTransceiverInit : public bindings::InputDictionaryBase {
  
  public:
static RTCRtpTransceiverInit* Create() {
  return MakeGarbageCollected<RTCRtpTransceiverInit>();
}
static RTCRtpTransceiverInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCRtpTransceiverInit>(isolate);
}
static RTCRtpTransceiverInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCRtpTransceiverInit();
explicit  RTCRtpTransceiverInit(v8::Isolate* isolate);

bool hasDirection() const {
  return true;
}
V8RTCRtpTransceiverDirection direction() const {
  return member_direction_;
}
void setDirection(V8RTCRtpTransceiverDirection value) {
  member_direction_ = value;
}
void setDirection(V8RTCRtpTransceiverDirection::Enum value) {
  member_direction_ = V8RTCRtpTransceiverDirection(value);
}

bool hasSendEncodings() const {
  return true;
}
const HeapVector<Member<RTCRtpEncodingParameters>>& sendEncodings() const {
  return member_send_encodings_;
}
void setSendEncodings(const HeapVector<Member<RTCRtpEncodingParameters>>& value);
void setSendEncodings(HeapVector<Member<RTCRtpEncodingParameters>>&& value);

bool hasStreams() const {
  return true;
}
const HeapVector<Member<MediaStream>>& streams() const {
  return member_streams_;
}
void setStreams(const HeapVector<Member<MediaStream>>& value);
void setStreams(HeapVector<Member<MediaStream>>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8RTCRtpTransceiverDirection member_direction_{V8RTCRtpTransceiverDirection::Enum::kSendrecv};
HeapVector<Member<RTCRtpEncodingParameters>> member_send_encodings_;
HeapVector<Member<MediaStream>> member_streams_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_TRANSCEIVER_INIT_H_
