// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_SEND_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_SEND_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_degradation_preference.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_parameters.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class RTCRtpEncodingParameters;

class MODULES_EXPORT RTCRtpSendParameters : public RTCRtpParameters {
  
  public:
static RTCRtpSendParameters* Create() {
  return MakeGarbageCollected<RTCRtpSendParameters>();
}
static RTCRtpSendParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCRtpSendParameters>(isolate);
}
static RTCRtpSendParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCRtpSendParameters();
explicit  RTCRtpSendParameters(v8::Isolate* isolate);

bool hasDegradationPreference() const {
  return has_degradation_preference_;
}
V8RTCDegradationPreference degradationPreference() const {
  DCHECK(hasDegradationPreference());
return member_degradation_preference_;
}
V8RTCDegradationPreference getDegradationPreferenceOr(V8RTCDegradationPreference fallback_value) const {
  if (!hasDegradationPreference()) {
  return fallback_value;
}
return member_degradation_preference_;
}
void setDegradationPreference(V8RTCDegradationPreference value) {
  member_degradation_preference_ = value;
has_degradation_preference_ = true;
}
void setDegradationPreference(V8RTCDegradationPreference::Enum value) {
  member_degradation_preference_ = V8RTCDegradationPreference(value);
has_degradation_preference_ = true;
}

bool hasEncodings() const {
  return true;
}
const HeapVector<Member<RTCRtpEncodingParameters>>& encodings() const {
  return member_encodings_;
}
void setEncodings(const HeapVector<Member<RTCRtpEncodingParameters>>& value);
void setEncodings(HeapVector<Member<RTCRtpEncodingParameters>>&& value);

bool hasTransactionId() const {
  return true;
}
const String& transactionId() const {
  return member_transaction_id_;
}
void setTransactionId(const String& value);
void setTransactionId(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCRtpParameters::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_degradation_preference_ = false;

V8RTCDegradationPreference member_degradation_preference_{static_cast<V8RTCDegradationPreference::Enum>(0)};
HeapVector<Member<RTCRtpEncodingParameters>> member_encodings_;
String member_transaction_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_SEND_PARAMETERS_H_
