// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_HEADER_EXTENSION_PARAMETERS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_HEADER_EXTENSION_PARAMETERS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCRtpHeaderExtensionParameters : public bindings::DictionaryBase {
  
  public:
static RTCRtpHeaderExtensionParameters* Create() {
  return MakeGarbageCollected<RTCRtpHeaderExtensionParameters>();
}
static RTCRtpHeaderExtensionParameters* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCRtpHeaderExtensionParameters>(isolate);
}
static RTCRtpHeaderExtensionParameters* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCRtpHeaderExtensionParameters();
explicit  RTCRtpHeaderExtensionParameters(v8::Isolate* isolate);

bool hasEncrypted() const {
  return true;
}
bool encrypted() const {
  return member_encrypted_;
}
void setEncrypted(bool value) {
  member_encrypted_ = value;
}

bool hasId() const {
  return true;
}
uint16_t id() const {
  return member_id_;
}
void setId(uint16_t value) {
  member_id_ = value;
}

bool hasUri() const {
  return true;
}
const String& uri() const {
  return member_uri_;
}
void setUri(const String& value);
void setUri(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_encrypted_{false};
uint16_t member_id_;
String member_uri_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RTP_HEADER_EXTENSION_PARAMETERS_H_
