// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RECEIVED_RTP_STREAM_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RECEIVED_RTP_STREAM_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_rtp_stream_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCReceivedRtpStreamStats : public RTCRtpStreamStats {
  
  public:
static RTCReceivedRtpStreamStats* Create() {
  return MakeGarbageCollected<RTCReceivedRtpStreamStats>();
}
static RTCReceivedRtpStreamStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCReceivedRtpStreamStats>(isolate);
}
static RTCReceivedRtpStreamStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCReceivedRtpStreamStats();
explicit  RTCReceivedRtpStreamStats(v8::Isolate* isolate);

bool hasJitter() const {
  return has_jitter_;
}
double jitter() const {
  DCHECK(hasJitter());
return member_jitter_;
}
double getJitterOr(double fallback_value) const {
  if (!hasJitter()) {
  return fallback_value;
}
return member_jitter_;
}
void setJitter(double value) {
  member_jitter_ = value;
has_jitter_ = true;
}

bool hasPacketsLost() const {
  return has_packets_lost_;
}
int64_t packetsLost() const {
  DCHECK(hasPacketsLost());
return member_packets_lost_;
}
int64_t getPacketsLostOr(int64_t fallback_value) const {
  if (!hasPacketsLost()) {
  return fallback_value;
}
return member_packets_lost_;
}
void setPacketsLost(int64_t value) {
  member_packets_lost_ = value;
has_packets_lost_ = true;
}

bool hasPacketsReceived() const {
  return has_packets_received_;
}
uint64_t packetsReceived() const {
  DCHECK(hasPacketsReceived());
return member_packets_received_;
}
uint64_t getPacketsReceivedOr(uint64_t fallback_value) const {
  if (!hasPacketsReceived()) {
  return fallback_value;
}
return member_packets_received_;
}
void setPacketsReceived(uint64_t value) {
  member_packets_received_ = value;
has_packets_received_ = true;
}

bool hasPacketsReceivedWithCe() const {
  return has_packets_received_with_ce_;
}
uint64_t packetsReceivedWithCe() const {
  DCHECK(hasPacketsReceivedWithCe());
return member_packets_received_with_ce_;
}
uint64_t getPacketsReceivedWithCeOr(uint64_t fallback_value) const {
  if (!hasPacketsReceivedWithCe()) {
  return fallback_value;
}
return member_packets_received_with_ce_;
}
void setPacketsReceivedWithCe(uint64_t value) {
  member_packets_received_with_ce_ = value;
has_packets_received_with_ce_ = true;
}

bool hasPacketsReceivedWithEct1() const {
  return has_packets_received_with_ect_1_;
}
uint64_t packetsReceivedWithEct1() const {
  DCHECK(hasPacketsReceivedWithEct1());
return member_packets_received_with_ect_1_;
}
uint64_t getPacketsReceivedWithEct1Or(uint64_t fallback_value) const {
  if (!hasPacketsReceivedWithEct1()) {
  return fallback_value;
}
return member_packets_received_with_ect_1_;
}
void setPacketsReceivedWithEct1(uint64_t value) {
  member_packets_received_with_ect_1_ = value;
has_packets_received_with_ect_1_ = true;
}

bool hasPacketsReportedAsLost() const {
  return has_packets_reported_as_lost_;
}
uint64_t packetsReportedAsLost() const {
  DCHECK(hasPacketsReportedAsLost());
return member_packets_reported_as_lost_;
}
uint64_t getPacketsReportedAsLostOr(uint64_t fallback_value) const {
  if (!hasPacketsReportedAsLost()) {
  return fallback_value;
}
return member_packets_reported_as_lost_;
}
void setPacketsReportedAsLost(uint64_t value) {
  member_packets_reported_as_lost_ = value;
has_packets_reported_as_lost_ = true;
}

bool hasPacketsReportedAsLostButRecovered() const {
  return has_packets_reported_as_lost_but_recovered_;
}
uint64_t packetsReportedAsLostButRecovered() const {
  DCHECK(hasPacketsReportedAsLostButRecovered());
return member_packets_reported_as_lost_but_recovered_;
}
uint64_t getPacketsReportedAsLostButRecoveredOr(uint64_t fallback_value) const {
  if (!hasPacketsReportedAsLostButRecovered()) {
  return fallback_value;
}
return member_packets_reported_as_lost_but_recovered_;
}
void setPacketsReportedAsLostButRecovered(uint64_t value) {
  member_packets_reported_as_lost_but_recovered_ = value;
has_packets_reported_as_lost_but_recovered_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCRtpStreamStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 7;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_jitter_ = false;
bool has_packets_lost_ = false;
bool has_packets_received_ = false;
bool has_packets_received_with_ce_ = false;
bool has_packets_received_with_ect_1_ = false;
bool has_packets_reported_as_lost_ = false;
bool has_packets_reported_as_lost_but_recovered_ = false;

double member_jitter_;
int64_t member_packets_lost_;
uint64_t member_packets_received_;
uint64_t member_packets_received_with_ce_;
uint64_t member_packets_received_with_ect_1_;
uint64_t member_packets_reported_as_lost_;
uint64_t member_packets_reported_as_lost_but_recovered_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_RECEIVED_RTP_STREAM_STATS_H_
