// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_OUTBOUND_RTP_STREAM_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_OUTBOUND_RTP_STREAM_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_quality_limitation_reason.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_sent_rtp_stream_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCOutboundRtpStreamStats : public RTCSentRtpStreamStats {
  
  public:
static RTCOutboundRtpStreamStats* Create() {
  return MakeGarbageCollected<RTCOutboundRtpStreamStats>();
}
static RTCOutboundRtpStreamStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCOutboundRtpStreamStats>(isolate);
}
static RTCOutboundRtpStreamStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCOutboundRtpStreamStats();
explicit  RTCOutboundRtpStreamStats(v8::Isolate* isolate);

bool hasActive() const {
  return has_active_;
}
bool active() const {
  DCHECK(hasActive());
return member_active_;
}
bool getActiveOr(bool fallback_value) const {
  if (!hasActive()) {
  return fallback_value;
}
return member_active_;
}
void setActive(bool value) {
  member_active_ = value;
has_active_ = true;
}

bool hasContentType() const {
  return has_content_type_;
}
const String& contentType() const {
  DCHECK(hasContentType());
return member_content_type_;
}
String getContentTypeOr(const String& fallback_value) const;
String getContentTypeOr(String&& fallback_value) const;
void setContentType(const String& value);
void setContentType(String&& value);

bool hasEncoderImplementation() const {
  return has_encoder_implementation_;
}
const String& encoderImplementation() const {
  DCHECK(hasEncoderImplementation());
return member_encoder_implementation_;
}
String getEncoderImplementationOr(const String& fallback_value) const;
String getEncoderImplementationOr(String&& fallback_value) const;
void setEncoderImplementation(const String& value);
void setEncoderImplementation(String&& value);

bool hasEncodingIndex() const {
  return has_encoding_index_;
}
uint32_t encodingIndex() const {
  DCHECK(hasEncodingIndex());
return member_encoding_index_;
}
uint32_t getEncodingIndexOr(uint32_t fallback_value) const {
  if (!hasEncodingIndex()) {
  return fallback_value;
}
return member_encoding_index_;
}
void setEncodingIndex(uint32_t value) {
  member_encoding_index_ = value;
has_encoding_index_ = true;
}

bool hasFirCount() const {
  return has_fir_count_;
}
uint32_t firCount() const {
  DCHECK(hasFirCount());
return member_fir_count_;
}
uint32_t getFirCountOr(uint32_t fallback_value) const {
  if (!hasFirCount()) {
  return fallback_value;
}
return member_fir_count_;
}
void setFirCount(uint32_t value) {
  member_fir_count_ = value;
has_fir_count_ = true;
}

bool hasFrameHeight() const {
  return has_frame_height_;
}
uint32_t frameHeight() const {
  DCHECK(hasFrameHeight());
return member_frame_height_;
}
uint32_t getFrameHeightOr(uint32_t fallback_value) const {
  if (!hasFrameHeight()) {
  return fallback_value;
}
return member_frame_height_;
}
void setFrameHeight(uint32_t value) {
  member_frame_height_ = value;
has_frame_height_ = true;
}

bool hasFrameWidth() const {
  return has_frame_width_;
}
uint32_t frameWidth() const {
  DCHECK(hasFrameWidth());
return member_frame_width_;
}
uint32_t getFrameWidthOr(uint32_t fallback_value) const {
  if (!hasFrameWidth()) {
  return fallback_value;
}
return member_frame_width_;
}
void setFrameWidth(uint32_t value) {
  member_frame_width_ = value;
has_frame_width_ = true;
}

bool hasFramesEncoded() const {
  return has_frames_encoded_;
}
uint32_t framesEncoded() const {
  DCHECK(hasFramesEncoded());
return member_frames_encoded_;
}
uint32_t getFramesEncodedOr(uint32_t fallback_value) const {
  if (!hasFramesEncoded()) {
  return fallback_value;
}
return member_frames_encoded_;
}
void setFramesEncoded(uint32_t value) {
  member_frames_encoded_ = value;
has_frames_encoded_ = true;
}

bool hasFramesPerSecond() const {
  return has_frames_per_second_;
}
double framesPerSecond() const {
  DCHECK(hasFramesPerSecond());
return member_frames_per_second_;
}
double getFramesPerSecondOr(double fallback_value) const {
  if (!hasFramesPerSecond()) {
  return fallback_value;
}
return member_frames_per_second_;
}
void setFramesPerSecond(double value) {
  member_frames_per_second_ = value;
has_frames_per_second_ = true;
}

bool hasFramesSent() const {
  return has_frames_sent_;
}
uint32_t framesSent() const {
  DCHECK(hasFramesSent());
return member_frames_sent_;
}
uint32_t getFramesSentOr(uint32_t fallback_value) const {
  if (!hasFramesSent()) {
  return fallback_value;
}
return member_frames_sent_;
}
void setFramesSent(uint32_t value) {
  member_frames_sent_ = value;
has_frames_sent_ = true;
}

bool hasHeaderBytesSent() const {
  return has_header_bytes_sent_;
}
uint64_t headerBytesSent() const {
  DCHECK(hasHeaderBytesSent());
return member_header_bytes_sent_;
}
uint64_t getHeaderBytesSentOr(uint64_t fallback_value) const {
  if (!hasHeaderBytesSent()) {
  return fallback_value;
}
return member_header_bytes_sent_;
}
void setHeaderBytesSent(uint64_t value) {
  member_header_bytes_sent_ = value;
has_header_bytes_sent_ = true;
}

bool hasHugeFramesSent() const {
  return has_huge_frames_sent_;
}
uint32_t hugeFramesSent() const {
  DCHECK(hasHugeFramesSent());
return member_huge_frames_sent_;
}
uint32_t getHugeFramesSentOr(uint32_t fallback_value) const {
  if (!hasHugeFramesSent()) {
  return fallback_value;
}
return member_huge_frames_sent_;
}
void setHugeFramesSent(uint32_t value) {
  member_huge_frames_sent_ = value;
has_huge_frames_sent_ = true;
}

bool hasKeyFramesEncoded() const {
  return has_key_frames_encoded_;
}
uint32_t keyFramesEncoded() const {
  DCHECK(hasKeyFramesEncoded());
return member_key_frames_encoded_;
}
uint32_t getKeyFramesEncodedOr(uint32_t fallback_value) const {
  if (!hasKeyFramesEncoded()) {
  return fallback_value;
}
return member_key_frames_encoded_;
}
void setKeyFramesEncoded(uint32_t value) {
  member_key_frames_encoded_ = value;
has_key_frames_encoded_ = true;
}

bool hasMediaSourceId() const {
  return has_media_source_id_;
}
const String& mediaSourceId() const {
  DCHECK(hasMediaSourceId());
return member_media_source_id_;
}
String getMediaSourceIdOr(const String& fallback_value) const;
String getMediaSourceIdOr(String&& fallback_value) const;
void setMediaSourceId(const String& value);
void setMediaSourceId(String&& value);

bool hasMid() const {
  return has_mid_;
}
const String& mid() const {
  DCHECK(hasMid());
return member_mid_;
}
String getMidOr(const String& fallback_value) const;
String getMidOr(String&& fallback_value) const;
void setMid(const String& value);
void setMid(String&& value);

bool hasNackCount() const {
  return has_nack_count_;
}
uint32_t nackCount() const {
  DCHECK(hasNackCount());
return member_nack_count_;
}
uint32_t getNackCountOr(uint32_t fallback_value) const {
  if (!hasNackCount()) {
  return fallback_value;
}
return member_nack_count_;
}
void setNackCount(uint32_t value) {
  member_nack_count_ = value;
has_nack_count_ = true;
}

bool hasPacketsSentWithEct1() const {
  return has_packets_sent_with_ect_1_;
}
uint64_t packetsSentWithEct1() const {
  DCHECK(hasPacketsSentWithEct1());
return member_packets_sent_with_ect_1_;
}
uint64_t getPacketsSentWithEct1Or(uint64_t fallback_value) const {
  if (!hasPacketsSentWithEct1()) {
  return fallback_value;
}
return member_packets_sent_with_ect_1_;
}
void setPacketsSentWithEct1(uint64_t value) {
  member_packets_sent_with_ect_1_ = value;
has_packets_sent_with_ect_1_ = true;
}

bool hasPliCount() const {
  return has_pli_count_;
}
uint32_t pliCount() const {
  DCHECK(hasPliCount());
return member_pli_count_;
}
uint32_t getPliCountOr(uint32_t fallback_value) const {
  if (!hasPliCount()) {
  return fallback_value;
}
return member_pli_count_;
}
void setPliCount(uint32_t value) {
  member_pli_count_ = value;
has_pli_count_ = true;
}

bool hasPowerEfficientEncoder() const {
  return has_power_efficient_encoder_;
}
bool powerEfficientEncoder() const {
  DCHECK(hasPowerEfficientEncoder());
return member_power_efficient_encoder_;
}
bool getPowerEfficientEncoderOr(bool fallback_value) const {
  if (!hasPowerEfficientEncoder()) {
  return fallback_value;
}
return member_power_efficient_encoder_;
}
void setPowerEfficientEncoder(bool value) {
  member_power_efficient_encoder_ = value;
has_power_efficient_encoder_ = true;
}

bool hasPsnrMeasurements() const {
  return has_psnr_measurements_;
}
uint32_t psnrMeasurements() const {
  DCHECK(hasPsnrMeasurements());
return member_psnr_measurements_;
}
uint32_t getPsnrMeasurementsOr(uint32_t fallback_value) const {
  if (!hasPsnrMeasurements()) {
  return fallback_value;
}
return member_psnr_measurements_;
}
void setPsnrMeasurements(uint32_t value) {
  member_psnr_measurements_ = value;
has_psnr_measurements_ = true;
}

bool hasPsnrSum() const {
  return has_psnr_sum_;
}
const Vector<std::pair<String, double>>& psnrSum() const {
  DCHECK(hasPsnrSum());
return member_psnr_sum_;
}
Vector<std::pair<String, double>> getPsnrSumOr(const Vector<std::pair<String, double>>& fallback_value) const;
Vector<std::pair<String, double>> getPsnrSumOr(Vector<std::pair<String, double>>&& fallback_value) const;
void setPsnrSum(const Vector<std::pair<String, double>>& value);
void setPsnrSum(Vector<std::pair<String, double>>&& value);

bool hasQpSum() const {
  return has_qp_sum_;
}
uint64_t qpSum() const {
  DCHECK(hasQpSum());
return member_qp_sum_;
}
uint64_t getQpSumOr(uint64_t fallback_value) const {
  if (!hasQpSum()) {
  return fallback_value;
}
return member_qp_sum_;
}
void setQpSum(uint64_t value) {
  member_qp_sum_ = value;
has_qp_sum_ = true;
}

bool hasQualityLimitationDurations() const {
  return has_quality_limitation_durations_;
}
const Vector<std::pair<String, double>>& qualityLimitationDurations() const {
  DCHECK(hasQualityLimitationDurations());
return member_quality_limitation_durations_;
}
Vector<std::pair<String, double>> getQualityLimitationDurationsOr(const Vector<std::pair<String, double>>& fallback_value) const;
Vector<std::pair<String, double>> getQualityLimitationDurationsOr(Vector<std::pair<String, double>>&& fallback_value) const;
void setQualityLimitationDurations(const Vector<std::pair<String, double>>& value);
void setQualityLimitationDurations(Vector<std::pair<String, double>>&& value);

bool hasQualityLimitationReason() const {
  return has_quality_limitation_reason_;
}
V8RTCQualityLimitationReason qualityLimitationReason() const {
  DCHECK(hasQualityLimitationReason());
return member_quality_limitation_reason_;
}
V8RTCQualityLimitationReason getQualityLimitationReasonOr(V8RTCQualityLimitationReason fallback_value) const {
  if (!hasQualityLimitationReason()) {
  return fallback_value;
}
return member_quality_limitation_reason_;
}
void setQualityLimitationReason(V8RTCQualityLimitationReason value) {
  member_quality_limitation_reason_ = value;
has_quality_limitation_reason_ = true;
}
void setQualityLimitationReason(V8RTCQualityLimitationReason::Enum value) {
  member_quality_limitation_reason_ = V8RTCQualityLimitationReason(value);
has_quality_limitation_reason_ = true;
}

bool hasQualityLimitationResolutionChanges() const {
  return has_quality_limitation_resolution_changes_;
}
uint32_t qualityLimitationResolutionChanges() const {
  DCHECK(hasQualityLimitationResolutionChanges());
return member_quality_limitation_resolution_changes_;
}
uint32_t getQualityLimitationResolutionChangesOr(uint32_t fallback_value) const {
  if (!hasQualityLimitationResolutionChanges()) {
  return fallback_value;
}
return member_quality_limitation_resolution_changes_;
}
void setQualityLimitationResolutionChanges(uint32_t value) {
  member_quality_limitation_resolution_changes_ = value;
has_quality_limitation_resolution_changes_ = true;
}

bool hasRemoteId() const {
  return has_remote_id_;
}
const String& remoteId() const {
  DCHECK(hasRemoteId());
return member_remote_id_;
}
String getRemoteIdOr(const String& fallback_value) const;
String getRemoteIdOr(String&& fallback_value) const;
void setRemoteId(const String& value);
void setRemoteId(String&& value);

bool hasRetransmittedBytesSent() const {
  return has_retransmitted_bytes_sent_;
}
uint64_t retransmittedBytesSent() const {
  DCHECK(hasRetransmittedBytesSent());
return member_retransmitted_bytes_sent_;
}
uint64_t getRetransmittedBytesSentOr(uint64_t fallback_value) const {
  if (!hasRetransmittedBytesSent()) {
  return fallback_value;
}
return member_retransmitted_bytes_sent_;
}
void setRetransmittedBytesSent(uint64_t value) {
  member_retransmitted_bytes_sent_ = value;
has_retransmitted_bytes_sent_ = true;
}

bool hasRetransmittedPacketsSent() const {
  return has_retransmitted_packets_sent_;
}
uint64_t retransmittedPacketsSent() const {
  DCHECK(hasRetransmittedPacketsSent());
return member_retransmitted_packets_sent_;
}
uint64_t getRetransmittedPacketsSentOr(uint64_t fallback_value) const {
  if (!hasRetransmittedPacketsSent()) {
  return fallback_value;
}
return member_retransmitted_packets_sent_;
}
void setRetransmittedPacketsSent(uint64_t value) {
  member_retransmitted_packets_sent_ = value;
has_retransmitted_packets_sent_ = true;
}

bool hasRid() const {
  return has_rid_;
}
const String& rid() const {
  DCHECK(hasRid());
return member_rid_;
}
String getRidOr(const String& fallback_value) const;
String getRidOr(String&& fallback_value) const;
void setRid(const String& value);
void setRid(String&& value);

bool hasRtxSsrc() const {
  return has_rtx_ssrc_;
}
uint32_t rtxSsrc() const {
  DCHECK(hasRtxSsrc());
return member_rtx_ssrc_;
}
uint32_t getRtxSsrcOr(uint32_t fallback_value) const {
  if (!hasRtxSsrc()) {
  return fallback_value;
}
return member_rtx_ssrc_;
}
void setRtxSsrc(uint32_t value) {
  member_rtx_ssrc_ = value;
has_rtx_ssrc_ = true;
}

bool hasScalabilityMode() const {
  return has_scalability_mode_;
}
const String& scalabilityMode() const {
  DCHECK(hasScalabilityMode());
return member_scalability_mode_;
}
String getScalabilityModeOr(const String& fallback_value) const;
String getScalabilityModeOr(String&& fallback_value) const;
void setScalabilityMode(const String& value);
void setScalabilityMode(String&& value);

bool hasTargetBitrate() const {
  return has_target_bitrate_;
}
double targetBitrate() const {
  DCHECK(hasTargetBitrate());
return member_target_bitrate_;
}
double getTargetBitrateOr(double fallback_value) const {
  if (!hasTargetBitrate()) {
  return fallback_value;
}
return member_target_bitrate_;
}
void setTargetBitrate(double value) {
  member_target_bitrate_ = value;
has_target_bitrate_ = true;
}

bool hasTotalEncodeTime() const {
  return has_total_encode_time_;
}
double totalEncodeTime() const {
  DCHECK(hasTotalEncodeTime());
return member_total_encode_time_;
}
double getTotalEncodeTimeOr(double fallback_value) const {
  if (!hasTotalEncodeTime()) {
  return fallback_value;
}
return member_total_encode_time_;
}
void setTotalEncodeTime(double value) {
  member_total_encode_time_ = value;
has_total_encode_time_ = true;
}

bool hasTotalEncodedBytesTarget() const {
  return has_total_encoded_bytes_target_;
}
uint64_t totalEncodedBytesTarget() const {
  DCHECK(hasTotalEncodedBytesTarget());
return member_total_encoded_bytes_target_;
}
uint64_t getTotalEncodedBytesTargetOr(uint64_t fallback_value) const {
  if (!hasTotalEncodedBytesTarget()) {
  return fallback_value;
}
return member_total_encoded_bytes_target_;
}
void setTotalEncodedBytesTarget(uint64_t value) {
  member_total_encoded_bytes_target_ = value;
has_total_encoded_bytes_target_ = true;
}

bool hasTotalPacketSendDelay() const {
  return has_total_packet_send_delay_;
}
double totalPacketSendDelay() const {
  DCHECK(hasTotalPacketSendDelay());
return member_total_packet_send_delay_;
}
double getTotalPacketSendDelayOr(double fallback_value) const {
  if (!hasTotalPacketSendDelay()) {
  return fallback_value;
}
return member_total_packet_send_delay_;
}
void setTotalPacketSendDelay(double value) {
  member_total_packet_send_delay_ = value;
has_total_packet_send_delay_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCSentRtpStreamStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 35;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_active_ = false;
bool has_content_type_ = false;
bool has_encoder_implementation_ = false;
bool has_encoding_index_ = false;
bool has_fir_count_ = false;
bool has_frame_height_ = false;
bool has_frame_width_ = false;
bool has_frames_encoded_ = false;
bool has_frames_per_second_ = false;
bool has_frames_sent_ = false;
bool has_header_bytes_sent_ = false;
bool has_huge_frames_sent_ = false;
bool has_key_frames_encoded_ = false;
bool has_media_source_id_ = false;
bool has_mid_ = false;
bool has_nack_count_ = false;
bool has_packets_sent_with_ect_1_ = false;
bool has_pli_count_ = false;
bool has_power_efficient_encoder_ = false;
bool has_psnr_measurements_ = false;
bool has_psnr_sum_ = false;
bool has_qp_sum_ = false;
bool has_quality_limitation_durations_ = false;
bool has_quality_limitation_reason_ = false;
bool has_quality_limitation_resolution_changes_ = false;
bool has_remote_id_ = false;
bool has_retransmitted_bytes_sent_ = false;
bool has_retransmitted_packets_sent_ = false;
bool has_rid_ = false;
bool has_rtx_ssrc_ = false;
bool has_scalability_mode_ = false;
bool has_target_bitrate_ = false;
bool has_total_encode_time_ = false;
bool has_total_encoded_bytes_target_ = false;
bool has_total_packet_send_delay_ = false;

bool member_active_;
String member_content_type_;
String member_encoder_implementation_;
uint32_t member_encoding_index_;
uint32_t member_fir_count_;
uint32_t member_frame_height_;
uint32_t member_frame_width_;
uint32_t member_frames_encoded_;
double member_frames_per_second_;
uint32_t member_frames_sent_;
uint64_t member_header_bytes_sent_;
uint32_t member_huge_frames_sent_;
uint32_t member_key_frames_encoded_;
String member_media_source_id_;
String member_mid_;
uint32_t member_nack_count_;
uint64_t member_packets_sent_with_ect_1_;
uint32_t member_pli_count_;
bool member_power_efficient_encoder_;
uint32_t member_psnr_measurements_;
Vector<std::pair<String, double>> member_psnr_sum_;
uint64_t member_qp_sum_;
Vector<std::pair<String, double>> member_quality_limitation_durations_;
V8RTCQualityLimitationReason member_quality_limitation_reason_{static_cast<V8RTCQualityLimitationReason::Enum>(0)};
uint32_t member_quality_limitation_resolution_changes_;
String member_remote_id_;
uint64_t member_retransmitted_bytes_sent_;
uint64_t member_retransmitted_packets_sent_;
String member_rid_;
uint32_t member_rtx_ssrc_;
String member_scalability_mode_;
double member_target_bitrate_;
double member_total_encode_time_;
uint64_t member_total_encoded_bytes_target_;
double member_total_packet_send_delay_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_OUTBOUND_RTP_STREAM_STATS_H_
