// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_STATS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_STATS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_ice_candidate_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_ice_server_transport_protocol.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_ice_tcp_candidate_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_network_type.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_stats.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCIceCandidateStats : public RTCStats {
  
  public:
static RTCIceCandidateStats* Create() {
  return MakeGarbageCollected<RTCIceCandidateStats>();
}
static RTCIceCandidateStats* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCIceCandidateStats>(isolate);
}
static RTCIceCandidateStats* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCIceCandidateStats();
explicit  RTCIceCandidateStats(v8::Isolate* isolate);

bool hasAddress() const {
  return has_address_;
}
const String& address() const {
  DCHECK(hasAddress());
return member_address_;
}
String getAddressOr(const String& fallback_value) const;
String getAddressOr(String&& fallback_value) const;
void setAddress(const String& value);
void setAddress(String&& value);

bool hasCandidateType() const {
  return true;
}
V8RTCIceCandidateType candidateType() const {
  return member_candidate_type_;
}
void setCandidateType(V8RTCIceCandidateType value) {
  member_candidate_type_ = value;
}
void setCandidateType(V8RTCIceCandidateType::Enum value) {
  member_candidate_type_ = V8RTCIceCandidateType(value);
}

bool hasFoundation() const {
  return has_foundation_;
}
const String& foundation() const {
  DCHECK(hasFoundation());
return member_foundation_;
}
String getFoundationOr(const String& fallback_value) const;
String getFoundationOr(String&& fallback_value) const;
void setFoundation(const String& value);
void setFoundation(String&& value);

bool hasIp() const {
  return has_ip_;
}
const String& ip() const {
  DCHECK(hasIp());
return member_ip_;
}
String getIpOr(const String& fallback_value) const;
String getIpOr(String&& fallback_value) const;
void setIp(const String& value);
void setIp(String&& value);

bool hasIsRemote() const {
  return has_is_remote_;
}
bool isRemote() const {
  DCHECK(hasIsRemote());
return member_is_remote_;
}
bool getIsRemoteOr(bool fallback_value) const {
  if (!hasIsRemote()) {
  return fallback_value;
}
return member_is_remote_;
}
void setIsRemote(bool value) {
  member_is_remote_ = value;
has_is_remote_ = true;
}

bool hasNetworkType() const {
  return has_network_type_;
}
V8RTCNetworkType networkType() const {
  DCHECK(hasNetworkType());
return member_network_type_;
}
V8RTCNetworkType getNetworkTypeOr(V8RTCNetworkType fallback_value) const {
  if (!hasNetworkType()) {
  return fallback_value;
}
return member_network_type_;
}
void setNetworkType(V8RTCNetworkType value) {
  member_network_type_ = value;
has_network_type_ = true;
}
void setNetworkType(V8RTCNetworkType::Enum value) {
  member_network_type_ = V8RTCNetworkType(value);
has_network_type_ = true;
}

bool hasPort() const {
  return has_port_;
}
int32_t port() const {
  DCHECK(hasPort());
return member_port_;
}
int32_t getPortOr(int32_t fallback_value) const {
  if (!hasPort()) {
  return fallback_value;
}
return member_port_;
}
void setPort(int32_t value) {
  member_port_ = value;
has_port_ = true;
}

bool hasPriority() const {
  return has_priority_;
}
int32_t priority() const {
  DCHECK(hasPriority());
return member_priority_;
}
int32_t getPriorityOr(int32_t fallback_value) const {
  if (!hasPriority()) {
  return fallback_value;
}
return member_priority_;
}
void setPriority(int32_t value) {
  member_priority_ = value;
has_priority_ = true;
}

bool hasProtocol() const {
  return has_protocol_;
}
const String& protocol() const {
  DCHECK(hasProtocol());
return member_protocol_;
}
String getProtocolOr(const String& fallback_value) const;
String getProtocolOr(String&& fallback_value) const;
void setProtocol(const String& value);
void setProtocol(String&& value);

bool hasRelatedAddress() const {
  return has_related_address_;
}
const String& relatedAddress() const {
  DCHECK(hasRelatedAddress());
return member_related_address_;
}
String getRelatedAddressOr(const String& fallback_value) const;
String getRelatedAddressOr(String&& fallback_value) const;
void setRelatedAddress(const String& value);
void setRelatedAddress(String&& value);

bool hasRelatedPort() const {
  return has_related_port_;
}
int32_t relatedPort() const {
  DCHECK(hasRelatedPort());
return member_related_port_;
}
int32_t getRelatedPortOr(int32_t fallback_value) const {
  if (!hasRelatedPort()) {
  return fallback_value;
}
return member_related_port_;
}
void setRelatedPort(int32_t value) {
  member_related_port_ = value;
has_related_port_ = true;
}

bool hasRelayProtocol() const {
  return has_relay_protocol_;
}
V8RTCIceServerTransportProtocol relayProtocol() const {
  DCHECK(hasRelayProtocol());
return member_relay_protocol_;
}
V8RTCIceServerTransportProtocol getRelayProtocolOr(V8RTCIceServerTransportProtocol fallback_value) const {
  if (!hasRelayProtocol()) {
  return fallback_value;
}
return member_relay_protocol_;
}
void setRelayProtocol(V8RTCIceServerTransportProtocol value) {
  member_relay_protocol_ = value;
has_relay_protocol_ = true;
}
void setRelayProtocol(V8RTCIceServerTransportProtocol::Enum value) {
  member_relay_protocol_ = V8RTCIceServerTransportProtocol(value);
has_relay_protocol_ = true;
}

bool hasTcpType() const {
  return has_tcp_type_;
}
V8RTCIceTcpCandidateType tcpType() const {
  DCHECK(hasTcpType());
return member_tcp_type_;
}
V8RTCIceTcpCandidateType getTcpTypeOr(V8RTCIceTcpCandidateType fallback_value) const {
  if (!hasTcpType()) {
  return fallback_value;
}
return member_tcp_type_;
}
void setTcpType(V8RTCIceTcpCandidateType value) {
  member_tcp_type_ = value;
has_tcp_type_ = true;
}
void setTcpType(V8RTCIceTcpCandidateType::Enum value) {
  member_tcp_type_ = V8RTCIceTcpCandidateType(value);
has_tcp_type_ = true;
}

bool hasTransportId() const {
  return true;
}
const String& transportId() const {
  return member_transport_id_;
}
void setTransportId(const String& value);
void setTransportId(String&& value);

bool hasUrl() const {
  return has_url_;
}
const String& url() const {
  DCHECK(hasUrl());
return member_url_;
}
String getUrlOr(const String& fallback_value) const;
String getUrlOr(String&& fallback_value) const;
void setUrl(const String& value);
void setUrl(String&& value);

bool hasUsernameFragment() const {
  return has_username_fragment_;
}
const String& usernameFragment() const {
  DCHECK(hasUsernameFragment());
return member_username_fragment_;
}
String getUsernameFragmentOr(const String& fallback_value) const;
String getUsernameFragmentOr(String&& fallback_value) const;
void setUsernameFragment(const String& value);
void setUsernameFragment(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = RTCStats::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 16;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_address_ = false;
bool has_foundation_ = false;
bool has_ip_ = false;
bool has_is_remote_ = false;
bool has_network_type_ = false;
bool has_port_ = false;
bool has_priority_ = false;
bool has_protocol_ = false;
bool has_related_address_ = false;
bool has_related_port_ = false;
bool has_relay_protocol_ = false;
bool has_tcp_type_ = false;
bool has_url_ = false;
bool has_username_fragment_ = false;

String member_address_;
V8RTCIceCandidateType member_candidate_type_{static_cast<V8RTCIceCandidateType::Enum>(0)};
String member_foundation_;
String member_ip_;
bool member_is_remote_;
V8RTCNetworkType member_network_type_{static_cast<V8RTCNetworkType::Enum>(0)};
int32_t member_port_;
int32_t member_priority_;
String member_protocol_;
String member_related_address_;
int32_t member_related_port_;
V8RTCIceServerTransportProtocol member_relay_protocol_{static_cast<V8RTCIceServerTransportProtocol::Enum>(0)};
V8RTCIceTcpCandidateType member_tcp_type_{static_cast<V8RTCIceTcpCandidateType::Enum>(0)};
String member_transport_id_;
String member_url_;
String member_username_fragment_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_STATS_H_
