// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_ice_candidate_pair_stats.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"availableIncomingBitrate",
"availableOutgoingBitrate",
"bytesDiscardedOnSend",
"bytesReceived",
"bytesSent",
"consentRequestsSent",
"currentRoundTripTime",
"lastPacketReceivedTimestamp",
"lastPacketSentTimestamp",
"localCandidateId",
"nominated",
"packetsDiscardedOnSend",
"packetsReceived",
"packetsSent",
"priority",
"remoteCandidateId",
"requestsReceived",
"requestsSent",
"responsesReceived",
"responsesSent",
"state",
"totalRoundTripTime",
"transportId",
"writable",
};


}  // namespace 

RTCIceCandidatePairStats* RTCIceCandidatePairStats::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCIceCandidatePairStats* dictionary = MakeGarbageCollected<RTCIceCandidatePairStats>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCIceCandidatePairStats";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCIceCandidatePairStats::RTCIceCandidatePairStats() {
  
}

 RTCIceCandidatePairStats::RTCIceCandidatePairStats(v8::Isolate* isolate) : RTCStats(isolate) {
  
}


































































void RTCIceCandidatePairStats::setLocalCandidateId(const String& value) {
  member_local_candidate_id_ = value;
}

void RTCIceCandidatePairStats::setLocalCandidateId(String&& value) {
  member_local_candidate_id_ = std::move(value);
}







































void RTCIceCandidatePairStats::setRemoteCandidateId(const String& value) {
  member_remote_candidate_id_ = value;
}

void RTCIceCandidatePairStats::setRemoteCandidateId(String&& value) {
  member_remote_candidate_id_ = std::move(value);
}












































void RTCIceCandidatePairStats::setTransportId(const String& value) {
  member_transport_id_ = value;
}

void RTCIceCandidatePairStats::setTransportId(String&& value) {
  member_transport_id_ = std::move(value);
}










void RTCIceCandidatePairStats::Trace(Visitor* visitor) const {
  RTCStats::Trace(visitor);
}

void RTCIceCandidatePairStats::FillTemplateProperties(Vector<std::string_view>& properties) const {
  RTCStats::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCIceCandidatePairStats::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  RTCStats::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAvailableIncomingBitrate()) {
  values[0] = ToV8Traits<IDLDouble>::ToV8(script_state, member_available_incoming_bitrate_);
DCHECK(!values[0].IsEmpty());
}
if (hasAvailableOutgoingBitrate()) {
  values[1] = ToV8Traits<IDLDouble>::ToV8(script_state, member_available_outgoing_bitrate_);
DCHECK(!values[1].IsEmpty());
}
if (hasBytesDiscardedOnSend()) {
  values[2] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_bytes_discarded_on_send_);
DCHECK(!values[2].IsEmpty());
}
if (hasBytesReceived()) {
  values[3] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_bytes_received_);
DCHECK(!values[3].IsEmpty());
}
if (hasBytesSent()) {
  values[4] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_bytes_sent_);
DCHECK(!values[4].IsEmpty());
}
if (hasConsentRequestsSent()) {
  values[5] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_consent_requests_sent_);
DCHECK(!values[5].IsEmpty());
}
if (hasCurrentRoundTripTime()) {
  values[6] = ToV8Traits<IDLDouble>::ToV8(script_state, member_current_round_trip_time_);
DCHECK(!values[6].IsEmpty());
}
if (hasLastPacketReceivedTimestamp()) {
  values[7] = ToV8Traits<IDLDouble>::ToV8(script_state, member_last_packet_received_timestamp_);
DCHECK(!values[7].IsEmpty());
}
if (hasLastPacketSentTimestamp()) {
  values[8] = ToV8Traits<IDLDouble>::ToV8(script_state, member_last_packet_sent_timestamp_);
DCHECK(!values[8].IsEmpty());
}
if (hasLocalCandidateId()) {
  values[9] = ToV8Traits<IDLString>::ToV8(script_state, member_local_candidate_id_);
DCHECK(!values[9].IsEmpty());
}
if (hasNominated()) {
  values[10] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_nominated_);
DCHECK(!values[10].IsEmpty());
}
if (hasPacketsDiscardedOnSend()) {
  values[11] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_packets_discarded_on_send_);
DCHECK(!values[11].IsEmpty());
}
if (hasPacketsReceived()) {
  values[12] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_packets_received_);
DCHECK(!values[12].IsEmpty());
}
if (hasPacketsSent()) {
  values[13] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_packets_sent_);
DCHECK(!values[13].IsEmpty());
}
if (hasPriority()) {
  values[14] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_priority_);
DCHECK(!values[14].IsEmpty());
}
if (hasRemoteCandidateId()) {
  values[15] = ToV8Traits<IDLString>::ToV8(script_state, member_remote_candidate_id_);
DCHECK(!values[15].IsEmpty());
}
if (hasRequestsReceived()) {
  values[16] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_requests_received_);
DCHECK(!values[16].IsEmpty());
}
if (hasRequestsSent()) {
  values[17] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_requests_sent_);
DCHECK(!values[17].IsEmpty());
}
if (hasResponsesReceived()) {
  values[18] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_responses_received_);
DCHECK(!values[18].IsEmpty());
}
if (hasResponsesSent()) {
  values[19] = ToV8Traits<IDLUnsignedLongLong>::ToV8(script_state, member_responses_sent_);
DCHECK(!values[19].IsEmpty());
}
if (hasState()) {
  values[20] = ToV8Traits<V8RTCStatsIceCandidatePairState>::ToV8(script_state, member_state_);
DCHECK(!values[20].IsEmpty());
}
if (hasTotalRoundTripTime()) {
  values[21] = ToV8Traits<IDLDouble>::ToV8(script_state, member_total_round_trip_time_);
DCHECK(!values[21].IsEmpty());
}
if (hasTransportId()) {
  values[22] = ToV8Traits<IDLString>::ToV8(script_state, member_transport_id_);
DCHECK(!values[22].IsEmpty());
}
if (hasWritable()) {
  values[23] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_writable_);
DCHECK(!values[23].IsEmpty());
}
}

const void* RTCIceCandidatePairStats::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCIceCandidatePairStats::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCIceCandidatePairStats::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
RTCStats::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "RTCIceCandidatePairStats";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("availableIncomingBitrate");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_available_incoming_bitrate_, member_available_incoming_bitrate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("availableOutgoingBitrate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_available_outgoing_bitrate_, member_available_outgoing_bitrate_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bytesDiscardedOnSend");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_bytes_discarded_on_send_, member_bytes_discarded_on_send_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bytesReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_bytes_received_, member_bytes_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("bytesSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_bytes_sent_, member_bytes_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("consentRequestsSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_consent_requests_sent_, member_consent_requests_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("currentRoundTripTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_current_round_trip_time_, member_current_round_trip_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lastPacketReceivedTimestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_last_packet_received_timestamp_, member_last_packet_received_timestamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("lastPacketSentTimestamp");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_last_packet_sent_timestamp_, member_last_packet_sent_timestamp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("localCandidateId");
constexpr bool is_required = true;
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), fallback_presence_var, member_local_candidate_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("nominated");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), has_nominated_, member_nominated_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsDiscardedOnSend");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[11].Get(isolate), has_packets_discarded_on_send_, member_packets_discarded_on_send_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[12].Get(isolate), has_packets_received_, member_packets_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("packetsSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[13].Get(isolate), has_packets_sent_, member_packets_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("priority");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[14].Get(isolate), has_priority_, member_priority_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("remoteCandidateId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[15].Get(isolate), fallback_presence_var, member_remote_candidate_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requestsReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[16].Get(isolate), has_requests_received_, member_requests_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requestsSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[17].Get(isolate), has_requests_sent_, member_requests_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("responsesReceived");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[18].Get(isolate), has_responses_received_, member_responses_received_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("responsesSent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLongLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[19].Get(isolate), has_responses_sent_, member_responses_sent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("state");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCStatsIceCandidatePairState, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[20].Get(isolate), fallback_presence_var, member_state_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("totalRoundTripTime");
if (!bindings::GetDictionaryMemberFromV8Object<IDLDouble, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[21].Get(isolate), has_total_round_trip_time_, member_total_round_trip_time_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("transportId");
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[22].Get(isolate), fallback_presence_var, member_transport_id_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("writable");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[23].Get(isolate), has_writable_, member_writable_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCIceCandidatePairStats::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
