// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_INIT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT RTCIceCandidateInit : public bindings::InputDictionaryBase {
  
  public:
static RTCIceCandidateInit* Create() {
  return MakeGarbageCollected<RTCIceCandidateInit>();
}
static RTCIceCandidateInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<RTCIceCandidateInit>(isolate);
}
static RTCIceCandidateInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  RTCIceCandidateInit();
explicit  RTCIceCandidateInit(v8::Isolate* isolate);

bool hasCandidate() const {
  return true;
}
const String& candidate() const {
  return member_candidate_;
}
void setCandidate(const String& value);
void setCandidate(String&& value);

bool hasSdpMLineIndex() const {
  return true;
}
const std::optional<uint16_t>& sdpMLineIndex() const {
  return member_sdp_m_line_index_;
}
void setSdpMLineIndex(const std::optional<uint16_t>& value) {
  member_sdp_m_line_index_ = value;
}
void setSdpMLineIndex(uint16_t value) {
  member_sdp_m_line_index_ = value;
}

bool hasSdpMid() const {
  return true;
}
const String& sdpMid() const {
  return member_sdp_mid_;
}
void setSdpMid(const String& value);
void setSdpMid(String&& value);

bool hasUsernameFragment() const {
  return true;
}
const String& usernameFragment() const {
  return member_username_fragment_;
}
void setUsernameFragment(const String& value);
void setUsernameFragment(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_candidate_{""};
std::optional<uint16_t> member_sdp_m_line_index_;
String member_sdp_mid_;
String member_username_fragment_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_RTC_ICE_CANDIDATE_INIT_H_
