// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_audio_frame.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_audio_frame_metadata.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_encoded_audio_frame_options.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/modules/peerconnection/rtc_encoded_audio_frame.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/v8_object_constructor.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



bool V8RTCEncodedAudioFrame::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow() || execution_context->IsDedicatedWorkerGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8RTCEncodedAudioFrame::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8RTCEncodedAudioFrame::InstallInterfaceTemplate,
    V8RTCEncodedAudioFrame::InstallContextDependentProperties,
    "RTCEncodedAudioFrame",
    nullptr,
    V8RTCEncodedAudioFrame::kThisTag,
    V8RTCEncodedAudioFrame::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& RTCEncodedAudioFrame::wrapper_type_info_ =
    V8RTCEncodedAudioFrame::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, RTCEncodedAudioFrame>::value,
    "RTCEncodedAudioFrame inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_rtc_encoded_audio_frame {


void TimestampAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_RTCEncodedAudioFrame_timestamp_Getter");
BLINK_BINDINGS_TRACE_EVENT("RTCEncodedAudioFrame.timestamp.get");
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8RTCEncodedAudioFrame_Timestamp_AttributeGetter);


v8::Local<v8::Object> v8_receiver = info.This();
RTCEncodedAudioFrame* blink_receiver = V8RTCEncodedAudioFrame::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->timestamp();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}



void DataAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_RTCEncodedAudioFrame_data_Getter");
BLINK_BINDINGS_TRACE_EVENT("RTCEncodedAudioFrame.data.get");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
RTCEncodedAudioFrame* blink_receiver = V8RTCEncodedAudioFrame::ToWrappableUnsafe(isolate, v8_receiver);
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
auto&& return_value = blink_receiver->data(execution_context);
static_assert(bindings::IsReturnTypeCompatible<DOMArrayBuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<DOMArrayBuffer>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void DataAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_RTCEncodedAudioFrame_data_Setter");
BLINK_BINDINGS_TRACE_EVENT("RTCEncodedAudioFrame.data.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
RTCEncodedAudioFrame* blink_receiver = V8RTCEncodedAudioFrame::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<DOMArrayBuffer>::NativeValue(isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setData(execution_context, arg1_value);

}

void ConstructorCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_RTCEncodedAudioFrame_constructor");
BLINK_BINDINGS_TRACE_EVENT("RTCEncodedAudioFrame.constructor");

v8::Isolate* isolate = info.GetIsolate();
if (!info.IsConstructCall()) {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::ConstructorCalledAsFunction());
return;
}
v8::Local<v8::Object> v8_receiver = info.This();
if (V8PerIsolateData::From(isolate)->InWrapperConstructor()) {
  bindings::V8SetReturnValue(info, v8_receiver);
return;
}

v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8RTCEncodedAudioFrame_Constructor);

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}

ExecutionContext* execution_context = current_execution_context;
ExceptionState exception_state(isolate);
auto&& arg1_original_frame = NativeValueTraits<RTCEncodedAudioFrame>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<RTCEncodedAudioFrameOptions>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg2_options;
if (info[1]->IsUndefined()) {
  arg2_options = RTCEncodedAudioFrameOptions::Create();
} else {
  arg2_options = NativeValueTraits<RTCEncodedAudioFrameOptions>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = RTCEncodedAudioFrame::Create(execution_context, arg1_original_frame, arg2_options, exception_state);
static_assert(bindings::IsReturnTypeCompatible<RTCEncodedAudioFrame, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
v8::Local<v8::Object> v8_wrapper = return_value->AssociateWithWrapper(isolate, V8RTCEncodedAudioFrame::GetWrapperTypeInfo(), v8_receiver);
bindings::V8SetReturnValue(info, v8_wrapper);
}

void GetMetadataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_RTCEncodedAudioFrame_getMetadata");
BLINK_BINDINGS_TRACE_EVENT("RTCEncodedAudioFrame.getMetadata");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
RTCEncodedAudioFrame* blink_receiver = V8RTCEncodedAudioFrame::ToWrappableUnsafe(isolate, v8_receiver);
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
auto&& return_value = blink_receiver->getMetadata(execution_context);
static_assert(bindings::IsReturnTypeCompatible<RTCEncodedAudioFrameMetadata, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<RTCEncodedAudioFrameMetadata>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void SetMetadataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_RTCEncodedAudioFrame_setMetadata");
BLINK_BINDINGS_TRACE_EVENT("RTCEncodedAudioFrame.setMetadata");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8RTCEncodedAudioFrame_SetMetadata_Method);

if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
RTCEncodedAudioFrame* blink_receiver = V8RTCEncodedAudioFrame::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
ExceptionState exception_state(isolate);
auto&& arg1_metadata = NativeValueTraits<RTCEncodedAudioFrameMetadata>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setMetadata(execution_context, arg1_metadata, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ToStringOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_RTCEncodedAudioFrame_toString");
BLINK_BINDINGS_TRACE_EVENT("RTCEncodedAudioFrame.toString");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
RTCEncodedAudioFrame* blink_receiver = V8RTCEncodedAudioFrame::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ExecutionContext* receiver_execution_context = ToExecutionContext(receiver_script_state);
ExecutionContext* execution_context = receiver_execution_context;
auto&& return_value = blink_receiver->toString(execution_context);
static_assert(bindings::IsReturnTypeCompatible<IDLString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}


}  // namespace v8_rtc_encoded_audio_frame

using namespace v8_rtc_encoded_audio_frame;

}  // namespace 

void V8RTCEncodedAudioFrame::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8RTCEncodedAudioFrame::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);

interface_function_template->SetCallHandler(ConstructorCallback);
interface_function_template->SetLength(1);
interface_function_template->SetInterfaceName(V8String(isolate, "RTCEncodedAudioFrame"));
interface_function_template->SetExceptionContext(v8::ExceptionContext::kConstructor);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8RTCEncodedAudioFrame::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"timestamp", TimestampAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"data", DataAttributeGetCallback, DataAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "RTCEncodedAudioFrame", kAttributeTable);
}





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"getMetadata", GetMetadataOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"toString", ToStringOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "RTCEncodedAudioFrame", kOperationTable);
}



}


void V8RTCEncodedAudioFrame::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;





v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
if ((feature_selector.IsAll() && RuntimeEnabledFeatures::RTCEncodedFrameSetMetadataEnabled(execution_context)) || feature_selector.IsAnyOf(mojom::blink::OriginTrialFeature::kRTCEncodedFrameSetMetadata)) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"setMetadata", SetMetadataOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "RTCEncodedAudioFrame", kOperationTable);
}


}


}  // namespace blink
