// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_configuration.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_rtc_ice_server.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/modules/peerconnection/rtc_certificate.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"bundlePolicy",
"certificates",
"encodedInsertableStreams",
"iceCandidatePoolSize",
"iceServers",
"iceTransportPolicy",
"iceTransports",
"rtcAudioJitterBufferFastAccelerate",
"rtcAudioJitterBufferMaxPackets",
"rtcAudioJitterBufferMinDelayMs",
"rtcpMuxPolicy",
};


}  // namespace 

RTCConfiguration* RTCConfiguration::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  RTCConfiguration* dictionary = MakeGarbageCollected<RTCConfiguration>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "RTCConfiguration";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 RTCConfiguration::RTCConfiguration() {
  
}

 RTCConfiguration::RTCConfiguration(v8::Isolate* isolate) {
  
}








HeapVector<Member<RTCCertificate>> RTCConfiguration::getCertificatesOr(const HeapVector<Member<RTCCertificate>>& fallback_value) const {
  if (!hasCertificates()) {
  return fallback_value;
}
return member_certificates_;
}

HeapVector<Member<RTCCertificate>> RTCConfiguration::getCertificatesOr(HeapVector<Member<RTCCertificate>>&& fallback_value) const {
  if (!hasCertificates()) {
  return std::move(fallback_value);
}
return member_certificates_;
}

void RTCConfiguration::setCertificates(const HeapVector<Member<RTCCertificate>>& value) {
  member_certificates_ = value;
has_certificates_ = true;
}

void RTCConfiguration::setCertificates(HeapVector<Member<RTCCertificate>>&& value) {
  member_certificates_ = std::move(value);
has_certificates_ = true;
}














HeapVector<Member<RTCIceServer>> RTCConfiguration::getIceServersOr(const HeapVector<Member<RTCIceServer>>& fallback_value) const {
  if (!hasIceServers()) {
  return fallback_value;
}
return member_ice_servers_;
}

HeapVector<Member<RTCIceServer>> RTCConfiguration::getIceServersOr(HeapVector<Member<RTCIceServer>>&& fallback_value) const {
  if (!hasIceServers()) {
  return std::move(fallback_value);
}
return member_ice_servers_;
}

void RTCConfiguration::setIceServers(const HeapVector<Member<RTCIceServer>>& value) {
  member_ice_servers_ = value;
has_ice_servers_ = true;
}

void RTCConfiguration::setIceServers(HeapVector<Member<RTCIceServer>>&& value) {
  member_ice_servers_ = std::move(value);
has_ice_servers_ = true;
}











































void RTCConfiguration::Trace(Visitor* visitor) const {
  visitor->Trace(member_certificates_);
visitor->Trace(member_ice_servers_);
bindings::DictionaryBase::Trace(visitor);
}

void RTCConfiguration::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void RTCConfiguration::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasBundlePolicy()) {
  values[0] = ToV8Traits<V8RTCBundlePolicy>::ToV8(script_state, member_bundle_policy_);
DCHECK(!values[0].IsEmpty());
}
if (hasCertificates()) {
  values[1] = ToV8Traits<IDLSequence<RTCCertificate>>::ToV8(script_state, member_certificates_);
DCHECK(!values[1].IsEmpty());
}
if (hasEncodedInsertableStreams()) {
  values[2] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_encoded_insertable_streams_);
DCHECK(!values[2].IsEmpty());
}
if (hasIceCandidatePoolSize()) {
  values[3] = ToV8Traits<IDLOctetEnforceRange>::ToV8(script_state, member_ice_candidate_pool_size_);
DCHECK(!values[3].IsEmpty());
}
if (hasIceServers()) {
  values[4] = ToV8Traits<IDLSequence<RTCIceServer>>::ToV8(script_state, member_ice_servers_);
DCHECK(!values[4].IsEmpty());
}
if (hasIceTransportPolicy()) {
  values[5] = ToV8Traits<V8RTCIceTransportPolicy>::ToV8(script_state, member_ice_transport_policy_);
DCHECK(!values[5].IsEmpty());
}
if (hasIceTransports()) {
  values[6] = ToV8Traits<V8RTCIceTransportPolicy>::ToV8(script_state, member_ice_transports_);
DCHECK(!values[6].IsEmpty());
}
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::RtcAudioJitterBufferMaxPacketsEnabled(execution_context)) {
  if (hasRtcAudioJitterBufferFastAccelerate()) {
  values[7] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_rtc_audio_jitter_buffer_fast_accelerate_);
DCHECK(!values[7].IsEmpty());
}
}
if (RuntimeEnabledFeatures::RtcAudioJitterBufferMaxPacketsEnabled(execution_context)) {
  if (hasRtcAudioJitterBufferMaxPackets()) {
  values[8] = ToV8Traits<IDLLong>::ToV8(script_state, member_rtc_audio_jitter_buffer_max_packets_);
DCHECK(!values[8].IsEmpty());
}
}
if (RuntimeEnabledFeatures::RtcAudioJitterBufferMaxPacketsEnabled(execution_context)) {
  if (hasRtcAudioJitterBufferMinDelayMs()) {
  values[9] = ToV8Traits<IDLLong>::ToV8(script_state, member_rtc_audio_jitter_buffer_min_delay_ms_);
DCHECK(!values[9].IsEmpty());
}
}
if (hasRtcpMuxPolicy()) {
  values[10] = ToV8Traits<V8RTCRtcpMuxPolicy>::ToV8(script_state, member_rtcp_mux_policy_);
DCHECK(!values[10].IsEmpty());
}
}

const void* RTCConfiguration::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> RTCConfiguration::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void RTCConfiguration::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "RTCConfiguration";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("bundlePolicy");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCBundlePolicy, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), fallback_presence_var, member_bundle_policy_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("certificates");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<RTCCertificate>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_certificates_, member_certificates_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("encodedInsertableStreams");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_encoded_insertable_streams_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iceCandidatePoolSize");
if (!bindings::GetDictionaryMemberFromV8Object<IDLOctetEnforceRange, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_ice_candidate_pool_size_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iceServers");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<RTCIceServer>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_ice_servers_, member_ice_servers_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iceTransportPolicy");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCIceTransportPolicy, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_ice_transport_policy_, member_ice_transport_policy_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("iceTransports");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCIceTransportPolicy, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_ice_transports_, member_ice_transports_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::RtcAudioJitterBufferMaxPacketsEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("rtcAudioJitterBufferFastAccelerate");
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_rtc_audio_jitter_buffer_fast_accelerate_, member_rtc_audio_jitter_buffer_fast_accelerate_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::RtcAudioJitterBufferMaxPacketsEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("rtcAudioJitterBufferMaxPackets");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), has_rtc_audio_jitter_buffer_max_packets_, member_rtc_audio_jitter_buffer_max_packets_, class_like_name, exception_state)) {
  return;
}
}
if (RuntimeEnabledFeatures::RtcAudioJitterBufferMaxPacketsEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("rtcAudioJitterBufferMinDelayMs");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_rtc_audio_jitter_buffer_min_delay_ms_, member_rtc_audio_jitter_buffer_min_delay_ms_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("rtcpMuxPolicy");
if (!bindings::GetDictionaryMemberFromV8Object<V8RTCRtcpMuxPolicy, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_rtcp_mux_policy_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> RTCConfiguration::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
