// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_push_message_data.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_blob.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/fileapi/blob.h"
#include "third_party/blink/renderer/modules/push_messaging/push_message_data.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



bool V8PushMessageData::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsServiceWorkerGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8PushMessageData::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8PushMessageData::InstallInterfaceTemplate,
    nullptr,
    "PushMessageData",
    nullptr,
    V8PushMessageData::kThisTag,
    V8PushMessageData::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& PushMessageData::wrapper_type_info_ =
    V8PushMessageData::wrapper_type_info_;

// non-[ActiveScriptWrappable]
static_assert(
    !std::is_base_of<ActiveScriptWrappableBase, PushMessageData>::value,
    "PushMessageData inherits from ActiveScriptWrappable<> without "
    "[ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_push_message_data {

void ArrayBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PushMessageData_arrayBuffer");
BLINK_BINDINGS_TRACE_EVENT("PushMessageData.arrayBuffer");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
PushMessageData* blink_receiver = V8PushMessageData::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->arrayBuffer();
static_assert(bindings::IsReturnTypeCompatible<DOMArrayBuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<DOMArrayBuffer>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void BlobOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PushMessageData_blob");
BLINK_BINDINGS_TRACE_EVENT("PushMessageData.blob");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PushMessageData* blink_receiver = V8PushMessageData::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->blob();
static_assert(bindings::IsReturnTypeCompatible<Blob, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void BytesOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PushMessageData_bytes");
BLINK_BINDINGS_TRACE_EVENT("PushMessageData.bytes");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
PushMessageData* blink_receiver = V8PushMessageData::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->bytes();
static_assert(bindings::IsReturnTypeCompatible<NotShared<DOMUint8Array>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<NotShared<DOMUint8Array>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void JsonOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PushMessageData_json");
BLINK_BINDINGS_TRACE_EVENT("PushMessageData.json");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PushMessageData* blink_receiver = V8PushMessageData::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->json(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void TextOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_PushMessageData_text");
BLINK_BINDINGS_TRACE_EVENT("PushMessageData.text");





v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
PushMessageData* blink_receiver = V8PushMessageData::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->text();
static_assert(bindings::IsReturnTypeCompatible<IDLUSVString, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}


}  // namespace v8_push_message_data

using namespace v8_push_message_data;

}  // namespace 

void V8PushMessageData::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8PushMessageData::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8PushMessageData::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;





{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"arrayBuffer", ArrayBufferOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blob", BlobOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"json", JsonOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"text", TextOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "PushMessageData", kOperationTable);
}



}

void V8PushMessageData::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;





if (RuntimeEnabledFeatures::PushMessageDataBytesEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"bytes", BytesOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "PushMessageData", kOperationTable);
}


}



}  // namespace blink
