// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_USER_ENTITY_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_USER_ENTITY_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_entity.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT PublicKeyCredentialUserEntity : public PublicKeyCredentialEntity {
  
  public:
static PublicKeyCredentialUserEntity* Create() {
  return MakeGarbageCollected<PublicKeyCredentialUserEntity>();
}
static PublicKeyCredentialUserEntity* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PublicKeyCredentialUserEntity>(isolate);
}
static PublicKeyCredentialUserEntity* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PublicKeyCredentialUserEntity();
explicit  PublicKeyCredentialUserEntity(v8::Isolate* isolate);

bool hasDisplayName() const {
  return true;
}
const String& displayName() const {
  return member_display_name_;
}
void setDisplayName(const String& value);
void setDisplayName(String&& value);

bool hasId() const {
  return true;
}
V8UnionArrayBufferOrArrayBufferView* id() const {
  return member_id_.Get();
}
void setId(V8UnionArrayBufferOrArrayBufferView* value) {
  member_id_ = value;
DCHECK(member_id_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = PublicKeyCredentialEntity::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



String member_display_name_;
Member<V8UnionArrayBufferOrArrayBufferView> member_id_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_USER_ENTITY_H_
