// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_DESCRIPTOR_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_DESCRIPTOR_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/typed_arrays/array_buffer_view_helpers.h"
#include "third_party/blink/renderer/core/typed_arrays/dom_typed_array.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class V8UnionArrayBufferOrArrayBufferView;

class MODULES_EXPORT PublicKeyCredentialDescriptor : public bindings::DictionaryBase {
  
  public:
static PublicKeyCredentialDescriptor* Create() {
  return MakeGarbageCollected<PublicKeyCredentialDescriptor>();
}
static PublicKeyCredentialDescriptor* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PublicKeyCredentialDescriptor>(isolate);
}
static PublicKeyCredentialDescriptor* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PublicKeyCredentialDescriptor();
explicit  PublicKeyCredentialDescriptor(v8::Isolate* isolate);

bool hasId() const {
  return true;
}
V8UnionArrayBufferOrArrayBufferView* id() const {
  return member_id_.Get();
}
void setId(V8UnionArrayBufferOrArrayBufferView* value) {
  member_id_ = value;
DCHECK(member_id_);
}

bool hasTransports() const {
  return has_transports_;
}
const Vector<String>& transports() const {
  DCHECK(hasTransports());
return member_transports_;
}
Vector<String> getTransportsOr(const Vector<String>& fallback_value) const;
Vector<String> getTransportsOr(Vector<String>&& fallback_value) const;
void setTransports(const Vector<String>& value);
void setTransports(Vector<String>&& value);

bool hasType() const {
  return true;
}
const String& type() const {
  return member_type_;
}
void setType(const String& value);
void setType(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_transports_ = false;

Member<V8UnionArrayBufferOrArrayBufferView> member_id_;
Vector<String> member_transports_;
String member_type_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PUBLIC_KEY_CREDENTIAL_DESCRIPTOR_H_
