// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_creation_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authentication_extensions_client_inputs.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_authenticator_selection_criteria.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_descriptor.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_parameters.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_rp_entity.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_public_key_credential_user_entity.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"
#include "third_party/blink/renderer/platform/runtime_enabled_features.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"attestation",
"attestationFormats",
"authenticatorSelection",
"challenge",
"excludeCredentials",
"extensions",
"hints",
"pubKeyCredParams",
"rp",
"timeout",
"user",
};


}  // namespace 

PublicKeyCredentialCreationOptions* PublicKeyCredentialCreationOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  PublicKeyCredentialCreationOptions* dictionary = MakeGarbageCollected<PublicKeyCredentialCreationOptions>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "PublicKeyCredentialCreationOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 PublicKeyCredentialCreationOptions::PublicKeyCredentialCreationOptions() {
  
}

 PublicKeyCredentialCreationOptions::PublicKeyCredentialCreationOptions(v8::Isolate* isolate) {
  
}



String PublicKeyCredentialCreationOptions::getAttestationOr(const String& fallback_value) const {
  if (!hasAttestation()) {
  return fallback_value;
}
return member_attestation_;
}

String PublicKeyCredentialCreationOptions::getAttestationOr(String&& fallback_value) const {
  if (!hasAttestation()) {
  return std::move(fallback_value);
}
return member_attestation_;
}

void PublicKeyCredentialCreationOptions::setAttestation(const String& value) {
  member_attestation_ = value;
has_attestation_ = true;
}

void PublicKeyCredentialCreationOptions::setAttestation(String&& value) {
  member_attestation_ = std::move(value);
has_attestation_ = true;
}




void PublicKeyCredentialCreationOptions::setAttestationFormats(const Vector<String>& value) {
  member_attestation_formats_ = value;
}

void PublicKeyCredentialCreationOptions::setAttestationFormats(Vector<String>&& value) {
  member_attestation_formats_ = std::move(value);
}
















void PublicKeyCredentialCreationOptions::setExcludeCredentials(const HeapVector<Member<PublicKeyCredentialDescriptor>>& value) {
  member_exclude_credentials_ = value;
}

void PublicKeyCredentialCreationOptions::setExcludeCredentials(HeapVector<Member<PublicKeyCredentialDescriptor>>&& value) {
  member_exclude_credentials_ = std::move(value);
}











void PublicKeyCredentialCreationOptions::setHints(const Vector<String>& value) {
  member_hints_ = value;
}

void PublicKeyCredentialCreationOptions::setHints(Vector<String>&& value) {
  member_hints_ = std::move(value);
}




void PublicKeyCredentialCreationOptions::setPubKeyCredParams(const HeapVector<Member<PublicKeyCredentialParameters>>& value) {
  member_pub_key_cred_params_ = value;
}

void PublicKeyCredentialCreationOptions::setPubKeyCredParams(HeapVector<Member<PublicKeyCredentialParameters>>&& value) {
  member_pub_key_cred_params_ = std::move(value);
}




















void PublicKeyCredentialCreationOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_authenticator_selection_);
visitor->Trace(member_challenge_);
visitor->Trace(member_exclude_credentials_);
visitor->Trace(member_extensions_);
visitor->Trace(member_pub_key_cred_params_);
visitor->Trace(member_rp_);
visitor->Trace(member_user_);
bindings::DictionaryBase::Trace(visitor);
}

void PublicKeyCredentialCreationOptions::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void PublicKeyCredentialCreationOptions::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAttestation()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_attestation_);
DCHECK(!values[0].IsEmpty());
}
v8::Isolate* isolate = script_state->GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ExecutionContext* execution_context = ExecutionContext::From(current_context);
if (RuntimeEnabledFeatures::WebAuthenticationAttestationFormatsEnabled(execution_context)) {
  if (hasAttestationFormats()) {
  values[1] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_attestation_formats_);
DCHECK(!values[1].IsEmpty());
}
}
if (hasAuthenticatorSelection()) {
  values[2] = ToV8Traits<AuthenticatorSelectionCriteria>::ToV8(script_state, member_authenticator_selection_.Get());
DCHECK(!values[2].IsEmpty());
}
if (hasChallenge()) {
  values[3] = ToV8Traits<V8UnionArrayBufferOrArrayBufferView>::ToV8(script_state, member_challenge_.Get());
DCHECK(!values[3].IsEmpty());
}
if (hasExcludeCredentials()) {
  values[4] = ToV8Traits<IDLSequence<PublicKeyCredentialDescriptor>>::ToV8(script_state, member_exclude_credentials_);
DCHECK(!values[4].IsEmpty());
}
if (hasExtensions()) {
  values[5] = ToV8Traits<AuthenticationExtensionsClientInputs>::ToV8(script_state, member_extensions_.Get());
DCHECK(!values[5].IsEmpty());
}
if (hasHints()) {
  values[6] = ToV8Traits<IDLSequence<IDLString>>::ToV8(script_state, member_hints_);
DCHECK(!values[6].IsEmpty());
}
if (hasPubKeyCredParams()) {
  values[7] = ToV8Traits<IDLSequence<PublicKeyCredentialParameters>>::ToV8(script_state, member_pub_key_cred_params_);
DCHECK(!values[7].IsEmpty());
}
if (hasRp()) {
  values[8] = ToV8Traits<PublicKeyCredentialRpEntity>::ToV8(script_state, member_rp_.Get());
DCHECK(!values[8].IsEmpty());
}
if (hasTimeout()) {
  values[9] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_timeout_);
DCHECK(!values[9].IsEmpty());
}
if (hasUser()) {
  values[10] = ToV8Traits<PublicKeyCredentialUserEntity>::ToV8(script_state, member_user_.Get());
DCHECK(!values[10].IsEmpty());
}
}

const void* PublicKeyCredentialCreationOptions::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> PublicKeyCredentialCreationOptions::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void PublicKeyCredentialCreationOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "PublicKeyCredentialCreationOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("attestation");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_attestation_, member_attestation_, class_like_name, exception_state)) {
  return;
}
ExecutionContext* execution_context = ExecutionContext::From(current_context);
bool fallback_presence_var;
if (RuntimeEnabledFeatures::WebAuthenticationAttestationFormatsEnabled(execution_context)) {
  dictionary_from_v8_context.SetCurrentPropertyName("attestationFormats");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_attestation_formats_, class_like_name, exception_state)) {
  return;
}
}
dictionary_from_v8_context.SetCurrentPropertyName("authenticatorSelection");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticatorSelectionCriteria, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_authenticator_selection_, member_authenticator_selection_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("challenge");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<V8UnionArrayBufferOrArrayBufferView, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_challenge_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("excludeCredentials");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PublicKeyCredentialDescriptor>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), fallback_presence_var, member_exclude_credentials_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("extensions");
if (!bindings::GetDictionaryMemberFromV8Object<AuthenticationExtensionsClientInputs, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_extensions_, member_extensions_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hints");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<IDLString>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), fallback_presence_var, member_hints_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("pubKeyCredParams");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PublicKeyCredentialParameters>, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), fallback_presence_var, member_pub_key_cred_params_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rp");
if (!bindings::GetDictionaryMemberFromV8Object<PublicKeyCredentialRpEntity, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[8].Get(isolate), fallback_presence_var, member_rp_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("timeout");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[9].Get(isolate), has_timeout_, member_timeout_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("user");
if (!bindings::GetDictionaryMemberFromV8Object<PublicKeyCredentialUserEntity, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[10].Get(isolate), fallback_presence_var, member_user_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> PublicKeyCredentialCreationOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
