// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRIVATE_AGGREGATION_HISTOGRAM_CONTRIBUTION_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRIVATE_AGGREGATION_HISTOGRAM_CONTRIBUTION_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/bigint.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT PrivateAggregationHistogramContribution : public bindings::InputDictionaryBase {
  
  public:
static PrivateAggregationHistogramContribution* Create() {
  return MakeGarbageCollected<PrivateAggregationHistogramContribution>();
}
static PrivateAggregationHistogramContribution* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<PrivateAggregationHistogramContribution>(isolate);
}
static PrivateAggregationHistogramContribution* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  PrivateAggregationHistogramContribution();
explicit  PrivateAggregationHistogramContribution(v8::Isolate* isolate);

bool hasBucket() const {
  return true;
}
const BigInt& bucket() const {
  return member_bucket_;
}
void setBucket(const BigInt& value) {
  member_bucket_ = value;
}

bool hasFilteringId() const {
  return has_filtering_id_;
}
const BigInt& filteringId() const {
  DCHECK(hasFilteringId());
return member_filtering_id_;
}
BigInt getFilteringIdOr(const BigInt& fallback_value) const {
  if (!hasFilteringId()) {
  return fallback_value;
}
return member_filtering_id_;
}
void setFilteringId(const BigInt& value) {
  member_filtering_id_ = value;
has_filtering_id_ = true;
}

bool hasValue() const {
  return true;
}
int32_t value() const {
  return member_value_;
}
void setValue(int32_t value) {
  member_value_ = value;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_filtering_id_ = false;

BigInt member_bucket_;
BigInt member_filtering_id_;
int32_t member_value_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_PRIVATE_AGGREGATION_HISTOGRAM_CONTRIBUTION_H_
